// Name.cpp  Implementacja klasy Name.
#include "Name.h"                                // Definicja klasy Name.
#include "DebugStuff.h"                          // Kontrola kodu debugujcego.
#include <cstring>                               // Dla funkcji acuchowych w stylu C.
#include <cassert>                               // Dla asercji.

#include <iostream>
using namespace std;

// Konstruktor domylny.
Name::Name()
{
#ifdef CONSTRUCTOR_TRACE
  // led wywoania konstruktora.
  cout << "\nKonstruktor domylny klasy Name zosta wywoany.";
#endif

  // Przydzielenie pamici jednoelementowej tablicy przechowujcej puste acuchy.
  pFirstname = new char[1];
  pSurname = new char[1];

  pFirstname[0] = pSurname[0] = '\0';           // Przechowuje znak null.
}

// Konstruktor
Name::Name(const char* pFirst, const char* pSecond)
{
  // Sprawdzanie, czy argumenty nie s zerowe.
  assert(pFirst != 0);
  assert(pSecond != 0);

#ifdef CONSTRUCTOR_TRACE
  // ledzenie wywoa konstruktora.
  cout << "\nKonstruktor klasy Name zosta wywoany.";
#endif
  pFirstname = new char[strlen(pFirst)+1];
  strcpy(pFirstname, pFirst);
  pSurname = new char[strlen(pSecond)+1];
  strcpy(pSurname, pSecond);
}


// Zwracanie penej nazwy w postaci acucha zawierajcego imi, spacj i nazwisko.
// Argument musi by adresem tablicy znakw wystarczajcej do przechowania nazwy .char*.
char* Name::getName(char* pName) const
{
  assert(pName != 0);                                 // Weryfikacja niezerowych argumentw.

#ifdef FUNCTION_TRACE
  // ledzenie wywoa funkcji.
  cout << "\nName::getName() called.";
#endif

  strcpy(pName, pFirstname);                          // Kopiowanie imienia.
  strcat(pName, " ");                  // Dodawanie spacji.
  return strcat(pName, pSurname);      // Dodawanie nazwiska i zwracanie caoci.
} 

// Zwraca dugo caej nazwy.
size_t Name::getNameLength() const
{
#ifdef FUNCTION_TRACE
  // eldzenie wywoa funkcji.
  cout << "\nName::getNameLength() called.";
#endif
  return strlen(pFirstname)+strlen(pSurname)+1;
}

// Operator mniejszoci.
bool Name::operator<(const Name& name) const
{
  int result = strcmp(pSurname, name.pSurname);
  if(result < 0)
    return true;
  if(result == 0 && strcmp(pFirstname, name.pFirstname) < 0)
    return true;
  else
    return false;
}

// Operator wikszoci.
bool Name::operator>(const Name& name) const
{
  return name < *this;
}

// Operator rwnoci.
bool Name::operator==(const Name& name) const
{
  if(strcmp(pSurname, name.pSurname) == 0 &&
                                         strcmp(pFirstname, name.pFirstname) == 0)
    return true;
  else
    return false;
}

Name:: Name(const Name& rName)
{
  pFirstname = new char[strlen(rName.pFirstname)+1]; // Przydzielenie pamici dla imienia
  strcpy(pFirstname, rName.pFirstname);              // i jego skopiowanie.
  pSurname = new char[strlen(rName.pSurname)+1];     // To samo dla nazwiska...
  strcpy(pSurname, rName.pSurname);
}

Name::~Name()
{
  delete[] pFirstname;
  delete[] pSurname;
}

Name& Name::operator=(const Name& rName)
{
  if(this == &rName)                                 // // Jeeli lewa strona rwna jest prawej,
    return *this;                                    // zwr tylko ten obiekt.

  delete[] pFirstname;
  pFirstname = new char[strlen(rName.pFirstname)+1]; // Przydzielenie pamici dla imienia
  strcpy(pFirstname, rName.pFirstname);              // i jego skopiowanie.
  delete[] pSurname;
  pSurname = new char[strlen(rName.pSurname)+1];     // To samo dla nazwiska...
  strcpy(pSurname, rName.pSurname);
  return *this;
}
