// Soln9_5.cpp : main project file.

#include "stdafx.h"

using namespace System;

ref class BinaryTree
{
private:
  ref class Node
  {
  public:
    // Konstruktor wza.
    Node(int n) : value(n), left(nullptr), right(nullptr) {}

    // Utworzenie listy wartoci wzw.
    void listNode()
    {

      if(left != nullptr)               // Jeli jest lewy wze,
        left->listNode();               // wywietla jego warto.

      Console::Write(L"{0, 12}", value); // Wysya na wyjcie warto biecego wza.
      if(++listCount % 5 == 0)
        Console::WriteLine();

      if(right != nullptr)             // Jeli jest prawy wze,
        right->listNode();             // wywietla jego warto.
    }

    int value;                         // Warto wza.
    Node^ left;                        // Referencja do lewego wza.
    Node^ right;                       // Referencja do prawego wza.
    static int listCount;              // Licznik wysyanych na wyjcie wartoci.
  };

public:
  BinaryTree() : root(nullptr){}       // Konstruktor.

  void add(int n);                     // Dodaje warto do drzewa.
  void add(int n, Node^ node);         // Dodaje n wzgldem wza pNode.

  // Tworzy list wzw.
  void listNodes()
  {
    Node::listCount = 0;
    if(root == nullptr)
      Console::WriteLine(L"Binary tree is empty.");
    else 
      root->listNode();
  }

private:
   Node^ root;                         // Referencja do wza gwnego.
};

// Dodaje warto do drzewa.
void BinaryTree::add(int n)
{
  if(root == nullptr)                  // Jeli nie ma wza gwnego,
    root = gcnew Node(n);              // staje si nim nowy wze.
  else                                 // W przeciwnym przypadku,
    add(n, root);                      // wze ten zostaje dodany (recursywanie).
}

// Dodanie wartoci wzgldem danego wza.
void BinaryTree::add(int n, Node^ node)
{
  if(n == node->value)                 // Jeli warto jest rwna biecemu wzowi.
  { // Rwne wartoci zawsze dodaje jako lewy wze.
    Node^ newNode = gcnew Node(n);     // Tworzy nowy wze dla wartoci.
    Node^ temp = node->left;           
    node->left = newNode;              
    newNode->left = temp;              
  }
  else if(n > node->value)             // Jeli nowa warto jest wiksza od wartoci prawego wza,
  {                                    // musi pj na praw stron.
    if(node->right == nullptr)        // Jeli wic nie ma prawego wza,
      node->right = gcnew Node(n);     // ten nowy wze bdzie prawym wzem.
    else                               // W przeciwnym przypadku
      add(n, node->right);             // zostanie dodany pod prawym wzem (rekursywnie).
  }
  else                                 // Nowa liczba jest mniejsza od wartoci biecego wza.
  {
    if(node->left == nullptr)          // Jeli wic nie ma lewego wza,
      node->left = gcnew Node(n);      // ten nowy wze bdzie lewym wzem.
    else                               // W przeciwnym razie
      add(n, node->left);              // zostanie dodany pod lewym wzem (rekursywnie).
  }
}

int main(array<System::String ^> ^args)
{
  BinaryTree^ tree = gcnew BinaryTree; // Tworzy drzewo binarne.
  unsigned int number = 0;             // Zapisuje liczb do dodania do drzewa.
  Random^ generator = gcnew Random;

  Console::WriteLine(L"Losowe wartoci wstawione do drzewa:");

  // Add 100 random number to the tree
  for(int i = 0 ; i<100 ; i++)
  {
    number = generator->Next(1, 10000);
    tree->add(number);
    Console::Write(L"{0,12}",number);
    if((i+1) % 5 == 0)
      Console::WriteLine();
  }
  Console::WriteLine(L"Dane wyjciowe z drzewa:");
  tree->listNodes();

   return 0;
}
