// Soln8_5.cpp

#include <iostream>                   // Dla funkcji wejcia-wyjcia.
#include <cstring>

using std::cout;
using std::endl;

class CSimpleString
{
private:
   size_t len;
   char* buff;
public:
   CSimpleString(const char* p = 0);
   CSimpleString(const CSimpleString& s);
   CSimpleString(char c, int count=1);
   CSimpleString(int i);
   ~CSimpleString();

   CSimpleString& operator=(const CSimpleString& rhs);
   CSimpleString& operator+=(const CSimpleString& rhs);
   CSimpleString concat(const CSimpleString& s2) const;
   void print();
};

CSimpleString::CSimpleString(char c, int count) : len(0), buff(0)
{
   len = count;
   if (len > 0)
   {
      buff = new char[len+1];
      memset(buff, c, len);
      buff[len] = '\0';
   }
}

CSimpleString::CSimpleString(int i) : len(0), buff(0)
{
   char sTmp[20];
   _itoa_s(i, sTmp, 20, 10);

   len = strlen(sTmp);
   if (len > 0)
   {
      buff = new char[len+1];
      strcpy_s(buff, len+1, sTmp);
   }
}

CSimpleString::CSimpleString(const char* p) : len(0), buff(0)
{
   if (p != 0)
   {
      len = strlen(p);
      if (len > 0)
      {
         buff = new char[len+1];
         strcpy_s(buff, len+1, p);
      }
   }
}

CSimpleString::CSimpleString(const CSimpleString& s)
{
   len = s.len;
   buff = new char[len+1];
   strcpy_s(buff, len+1, s.buff);
}

CSimpleString::~CSimpleString()
{
   delete buff;
}

CSimpleString& CSimpleString::operator=(const CSimpleString& rhs)
{
   if (&rhs != this)
   {
     len = rhs.len;
     delete buff;
     buff = new char[len+1];
     strcpy_s(buff, len+1, rhs.buff);
   }

   return *this;
}

CSimpleString& CSimpleString::operator+=(const CSimpleString& rhs)
{
   char* t = buff;
   size_t length = len + rhs.len + 1;
   buff = new char[length];
   strcpy_s(buff,length, t);
   strcat_s(buff, length, rhs.buff);
   len += rhs.len;
   delete[] t;

   return *this;
}

CSimpleString CSimpleString::concat(const CSimpleString& s2) const
{
  size_t length = len + s2.len + 1;
   char* tmp = new char[length];
   strcpy_s(tmp, length, buff);
   strcat_s(tmp, length, s2.buff);

   CSimpleString t(tmp);

   return t;
}

CSimpleString operator+(const CSimpleString& s1, const CSimpleString& s2)
{
   return s1.concat(s2);
}

void CSimpleString::print()
{
   cout << buff;
}

int main()
{
   CSimpleString s1 = "hello";
   CSimpleString s2;

   s2 = s1;
   CSimpleString marker = CSimpleString('*', 30);
   marker.print();
   cout << endl;

   cout << "s1 = \"";
   s1.print();

   cout << "\"" << endl;

   cout << "s2 = \"";
   s2.print();
   cout << "\"" << endl;

   int n = 7890;

   CSimpleString nStr = CSimpleString(n);

   cout << n << " jako acuch to \"";
   nStr.print();
   cout << "\"" << endl;

   CSimpleString* pStr = &s2;

   s2 = *pStr;      // s2 = s2
   cout << "s2 = \"";
   s2.print();
   cout << "\"" << endl;

   s1 += " world!";

   cout << "s1 = \"";
   s1.print();

   cout << "\"" << endl;

   marker.print();
   cout << endl;
   return 0;
}
