// Soln8_2.cpp

#include <iostream>                   // Dla funkcji wejcia-wyjcia.
#include <cstring>

using std::cout;
using std::endl;

class CSimpleString
{
private:
   size_t len;
   char* buff;
public:
   CSimpleString(const char* p = 0);
   CSimpleString(const CSimpleString& s);
   ~CSimpleString();

   CSimpleString& operator=(const CSimpleString& rhs);
   void print();
};

CSimpleString::CSimpleString(const char* p) : len(0), buff(0)
{
   if (p != 0)
   {
      len = strlen(p);
      if (len > 0)
      {
         buff = new char[len+1];
         strcpy_s(buff, len+1, p);
      }
   }
}

CSimpleString::CSimpleString(const CSimpleString& s)
{
   len = s.len;
   buff = new char[len+1];
   strcpy_s(buff, len+1, s.buff);
}

CSimpleString::~CSimpleString()
{
   delete buff;
}

CSimpleString& CSimpleString::operator=(const CSimpleString& rhs)
{
   len = rhs.len;
   delete buff;
   buff = new char[len+1];
   strcpy_s(buff, len+1, rhs.buff);

   return *this;
}

void CSimpleString::print()
{
   cout << buff;
}

int main()
{
   CSimpleString s1 = "hello";
   CSimpleString s2;

   s2 = s1;

   cout << "s1 = \"";
   s1.print();
   cout << "\"" << endl;

   cout << "s2 = \"";
   s2.print();
   cout << "\"" << endl;

   return 0;
}
