// BoxOperators.cpp
// Operacje na obiektach klasy CBox, ktre nie wymagaj dostpu do skadowych prywatnych.
#include "Box.h"

// Funkcja sprawdzajca, czy staa jest > ni obiekt klasy CBox.
bool operator>(const double& value, const CBox& aBox)
{ return value > aBox.Volume(); }

// Funkcja sprawdzajca, czy staa jest < ni obiekt klasy CBox.
bool operator<(const double& value, const CBox& aBox)
{ return value < aBox.Volume(); }

// Funkcja sprawdzajca, czy obiekt klasy CBox jest > od staej.
bool operator>(const CBox& aBox, const double& value)
{ return value < aBox; }

// Funkcja sprawdzajca, czy obiekt klasy CBox jest < od staej.
bool operator<( const CBox& aBox, const double& value)
{ return value > aBox; }

// Funkcja sprawdzajca, czy staa jest >= od obiektu klasy CBox.
bool operator>=(const double& value, const CBox& aBox)
{ return value >= aBox.Volume(); }

// Funkcja sprawdzajca, czy staa jest <= od obiektu klasy CBox.
bool operator<=(const double& value, const CBox& aBox)
{ return value <= aBox.Volume(); }

// Funkcja sprawdzajca, czy obiekt klasy CBox jest >= od staej.
bool operator>=( const CBox& aBox, const double& value)
{ return value <= aBox; }

// Funkcja sprawdzajca, czy obiekt klasy CBox jest <= od staej.
bool operator<=( const CBox& aBox, const double& value)
{ return value >= aBox; }

// Funkcja sprawdzajca, czy staa jest == obiektowi klasy CBox.
bool operator==(const double& value, const CBox& aBox)
{ return value == aBox.Volume(); }

// Funkcja sprawdzajca, czy obiekt klasy CBox jest == staej.
bool operator==(const CBox& aBox, const double& value)
{ return value == aBox; }

// Operator mnoenia klasy CBox - n*aBox.
CBox operator*(int n, const CBox& aBox)
{ return aBox * n; }

// Operator zwracajcy pojmeno wolnej przestrzeni zapakowanego obiektu klasy CBox.
double operator%( const CBox& aBox, const CBox& bBox)
{ return aBox.Volume() - (aBox / bBox) * bBox.Volume(); }
