// Cw8_07.cpp
// Uywanie szablonu klasy.
#include <iostream>
using std::cout;
using std::endl;
// Wstaw tutaj definicj klasy CBox z programu Cw8_06.cpp.
// Definicja szablonu klasy CSamples. 
template <class T> class CSamples 
{
  public:
    // Konstruktory
    CSamples(const T values[], int count);
    CSamples(const T& value);
    CSamples(){ m_Free = 0; }

    bool Add(const T& value);          // Wstawianie jakiej wartoci.
    T Max() const;                     // Obliczanie maksimum.

  private:
    T m_Values[100];                   // Tablica przechowujca prbki.
    int m_Free;                        // Indeks wolnej lokalizacji w tablicy m_Values.
};

// Definicja szablonu konstruktora przyjmujcego tablic prbek.
template<class T> CSamples<T>::CSamples(const T values[], int count)
{
  m_Free = count < 100? count:100;     // Nie przekraczaj rozmiaru tablicy.
  for(int i = 0; i < m_Free; i++)
    m_Values[i] = values[i];           // Przechowuje liczb prbek.
}

// Konstruktor przyjmujcy pojedyncz jednostk.
template<class T> CSamples<T>::CSamples(const T& value)
{
  m_Values[0] = value;                 // Zapisuje prbk.
  m_Free = 1;                          // Nastpna jest wolna.
}

// Funkcja dodajca jednostk.
template<class T> bool CSamples<T>::Add(const T& value)
{
  bool OK = m_Free < 100;              // Wskazuje, e jest wolne miejsce.
  if(OK)
    m_Values[m_Free++] = value;        // Prawda, wic zapisz warto.
  return OK;
}

// Funkcja znajdujca maksymaln jednostk.
template<class T> T CSamples<T>::Max() const
{
  T theMax = m_Free ? m_Values[0] : 0; // Ustaw pierwsz prbk lub 0 jako maksimum.
  for(int i = 1; i < m_Free; i++)      // Sprawd wszystkie prbki.
    if(m_Values[i] > theMax)
      theMax = m_Values[i];            // Przechowuje dowoln wiksz prbk.
  return theMax;
}

int main()
{
  CBox boxes[] = {                          // Utwrz tablic z obiektw pudeek.
                   CBox(8.0, 5.0, 2.0),     // Zainicjalizuj je...
                   CBox(5.0, 4.0, 6.0),
                   CBox(4.0, 3.0, 3.0)
                 };

  // Tworzenie obiektu CSamples w celu przechowywania obiektw klasy CBox.
  CSamples<CBox> myBoxes(boxes, sizeof boxes / sizeof CBox);

  CBox maxBox = myBoxes.Max();              // Pobierz najwikszy obiekt
  cout << endl                              // i wywietl jego pojemno.
       << "Najwiksze pudeko ma pojemno "
       << maxBox.Volume()
       << endl;
  return 0;
}
