// Cw8_05.cpp
// Szlifowanie przeadowywania operatora kopiowania.
#include <iostream>
#include <cstring>
using std::cout;
using std::endl;

class CMessage
{
  private:
    char* pmessage;                    // Wskanik do acucha obiektu.

  public:
    // Funkcja wywietlajca komunikat.
    void ShowIt() const
    {
      cout << endl << pmessage;
    }

    //Funkcja konwertujca komunikat na *.
    void Reset()
    {
      char* temp = pmessage;
      while(*temp)
        *(temp++) = '*';
    }

    // Przeadowany operator przypisania dla obiektw klasy CMessage.
    CMessage& operator=(const CMessage& aMess)
    {
      if(this == &aMess)               // Sprawdzanie adresw, jeli s takie same,
        return *this;                  // zwr pierwszy operand.

      // Zwolnienie pamici dla pierwszego operandu.
      delete[] pmessage;
      pmessage = new char[ strlen(aMess.pmessage) +1];

      // Skopiowanie acucha drugiego operandu do pierwszego.
      strcpy(this->pmessage, aMess.pmessage);

      // Zwrcenie referencji do pierwszego operandu.
      return *this;
    }

    // Definicja konstruktora.
    CMessage(const char* text = "Komunikat domylny")
    {
      pmessage = new char[ strlen(text) +1 ]; // Przydzielenie pamici dla tekstu.
      strcpy(pmessage, text);                 // Skopiowanie tekstu do nowego obszaru pamici.
    }

    // Destruktor zwalniajcy pami przydzielon przez operator new.
    ~CMessage()
    {
      cout << "Destruktor zosta wywoany."     // ledzi, co si dzieje.
           << endl;
      delete[] pmessage;               // Zwolnienie pamici przydzielonej wskanikowi.
    }
};

int main()
{
  CMessage motto1("Gupiemu szczcie sprzyja.");
  CMessage motto2;

  cout << "motto2 zawiera - ";
  motto2.ShowIt();
  cout << endl;

  motto2 = motto1;                       // Uyj nowego operatora przypisania.

  cout << "motto2 zawiera - ";
   motto2.ShowIt();
  cout << endl;

  motto1.Reset();                      // Ustawianie motto1 na * nie
                                       // ma wpywu na motto2.

  cout << "motto1 zawiera teraz - ";
  motto1.ShowIt();
  cout << endl;

  cout << "motto2 nadal zawiera - ";
  motto2.ShowIt();
  cout << endl;

  return 0;
}
