// Cw8_04.cpp
// Implementacja penego przeadowania operatora wikszoci.
#include <iostream>                    // Dla strumienia wejcia-wyjcia.
using std::cout;
using std::endl;

class CBox                             // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja konstruktora.
    CBox(double lv = 1.0, double wv = 1.0, double hv = 1.0):
                            m_Length(lv), m_Width(wv), m_Height(hv)
    {
      cout << endl << "Konstruktor zosta wywoany.";
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

    // Funkcja operatora wikszoci porwnujca
    // pojemnoci obiektw klasy CBox.
    bool operator>(const CBox& aBox) const
    {
      return this->Volume() > aBox.Volume();
    }

    // Funkcja porwnujca obiekt klasy CBox ze sta.
    bool operator>(const double& value) const
    {
      return this->Volume() > value;
    }

    // Definicja destruktora.
    ~CBox()
    { cout << "Destruktor zosta wywoany." << endl;}

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.
};

int operator>(const double& value, const CBox& aBox); // Prototyp funkcji.

int main()
{
  CBox smallBox(4.0, 2.0, 1.0);
  CBox mediumBox(10.0, 4.0, 2.0);

  if(mediumBox > smallBox)
    cout << endl
         << "Pudeko mediumBox jest wiksze ni smallBox.";

  if(mediumBox > 50.0)
    cout << endl
         << "Pojemno pudeka mediumBox jest wiksza ni 50.";
  else
    cout << endl
         << "Pojemno pudeka mediumBox nie jest wiksza ni 50.";

  if(10.0 > smallBox)
    cout << endl
         << "Pojemno pudeka smallBox jest mniejsza ni 10.";
  else
    cout << endl
         << "Pojemno pudeka smallBox nie jest mniejsza ni 10.";

  cout << endl;
  return 0;
}

// Funkcja porwnujca sta z obiektem klasy CBox.
int operator>(const double& value, const CBox& aBox)
{
  return value > aBox.Volume();
}
