// Cw8_01.cpp
// Klasa z jawnym destruktorem.
#include <iostream>
using std::cout;
using std::endl;

class CBox                     // Definicja klasy o zasigu globalnym.
{
  public:
    // Definicja destruktora.
    ~CBox()
    {
      cout << "Destruktor zosta wywoany." << endl;
    }

    // Definicja konstruktora.
    CBox(double lv = 1.0, double wv = 1.0, double hv = 1.0):
                                  m_Length(lv), m_Width(wv), m_Height(hv)
    {
      cout << endl << "Konstruktor zosta wywoany.";
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

    // Funkcja porwnujca dwa pudeka, zwracajca warto true,
    // jeeli pierwsze jest wiksze od drugiego, oraz false w przeciwnym przypadku.
    int compare(CBox* pBox) const
    {
      return this->Volume()  >  pBox->Volume();
    }

  private:
    double m_Length;         // Dugo pudeka w centymetrach.
    double m_Width;          // Szeroko pudeka w centymetrach.
    double m_Height;         // Wysoko pudeka w centymetrach.
};

// Funkcja pokazujca dziaanie destruktora klasy CBox.
int main()
{
  CBox boxes[5];              // Deklaracja tablicy zawierajcej obiekty klasy CBox.
  CBox cigar(8.0, 5.0, 1.0);  // Deklaracja obiektu cigar.
  CBox match(2.2, 1.1, 0.5);  // Deklaracja obiektu match.
  CBox* pB1 = &cigar;         // Inicjalizacja wskanika do adresu obiektu cigar.
  CBox* pB2 = 0;              // Inicjalizacja wskanika do CBox wartoci null.

  cout << endl
       << "Pojemno pudeka cigar wynosi "
       << pB1->Volume();      // Pojemno wskazywanego obiektu.

  pB2 = boxes;                // Ustawienie na adres tablicy.
  boxes[2] = match;           // Ustawienie trzeciego elementu na warto obiektu match.
  cout << endl
       << "Pojemno pudeka boxes[2] wynosi "
       << (pB2 + 2)->Volume();  // Uzyskiwanie dostpu poprzez wskanik.

  cout << endl;
  return 0;
}
