// Soln7_8.cpp

#include <iostream>                   // Dla funkcji wejcia-wyjcia.

using std::cout;
using std::endl;

class CStack
{
public:
   CStack() : next(0) {}
   void push(int i);
   int pop();
   void print();
   int peek();
private:
   int list[100];
   int next;
};

void CStack::push(int i)
{
   if (next < 99)
      list[next++] = i;
   else
      cout << "Bd! Przepenienie stosu." << endl;
}

int CStack::pop()
{
   if (next == 0)
   {
      cout << "Bd! Niedopenienie stosu." << endl;
      return 0;
   }
   else
     return list[--next];
}

void CStack::print()
{
   cout << '[';
   for(int i=next-1 ; i>=0 ; i--)
      cout << ' '<< list[i];
   cout << " ]\n";
}

int CStack::peek()
{
   if (next == 0)
   {
      cout << "Bd! Niedopenienie stosu." << endl;
      return 0;
   }
   else
      return list[next-1];
}

int main()
{
   CStack s;

   s.print();

   s.push(5);
   s.push(10);
   s.push(8);

   s.print();

   cout << "peek na wierzchu stosu = " << s.peek() << endl;
   s.print();
   cout << "usunicie wierzchu stosu = " << s.pop() << endl;
   cout << "usunicie wierzchu stosu = " << s.pop() << endl;
   s.print();
   cout << "usunicie wierzchu stosu = " << s.pop() << endl;
   cout << "usunicie wierzchu stosu = " << s.pop() << endl;

   return 0;
}

