// Cw7_12.cpp
// Uywanie statycznej zmiennej skadowej w klasie.
#include <iostream>
using std::cout;
using std::endl;

class CBox                             // Definicja klasy o zasigu globalnym.
{
  public:
    static int objectCount;            // Liczba istniejcych obiektw.

    // Definicja konstruktora.
    CBox(double lv, double bv = 1.0, double hv = 1.0)
    {
      cout << endl << "Konstruktor zosta wywoany.";
      m_Length = lv;                   // Ustawianie wartoci
      m_Width = bv;                    // zmiennych skadowych.
      m_Height = hv;                   
      objectCount++;
    }

    CBox()                             // Konstruktor domylny.
    {
      cout << endl
           << "Konstruktor domylny zosta wywoany.";
      m_Length = m_Width = m_Height = 1.0;
      objectCount++;
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume() const
    {
      return m_Length*m_Width*m_Height;
    }

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.
};

int CBox::objectCount = 0;             // Inicjalizacja skadowej statycznej klasy CBox.

int main()
{
  CBox boxes[5];                       // Deklaracja tablicy obiektw klasy CBox.
  CBox cigar(8.0, 5.0, 1.0);           // Deklaracja pudeka cigar.

  cout << endl << endl
       << "Liczba obiektw (przez klas) = "
       << CBox::objectCount;

  cout << endl
       << "Liczba obiektw (przez obiekt) = "
       << boxes[2].objectCount;

  cout << endl;
  return 0;
}
