// Cw7_08.cpp
// Tworzenie funkcji zaprzyjanionej klasy.
#include <iostream>
using std::cout;
using std::endl;

class CBox                             // Definicja klasy w zasigu globalnym.
{
  public:

    // Definicja konstruktora.
    CBox(double lv = 1.0, double bv = 1.0, double hv = 1.0)
    {
      cout << endl << "Konstruktor zosta wywoany.";
      m_Length = lv;                   // Ustawianie wartoci
      m_Width = bv;                    // zmiennych skadowych.
      m_Height = hv;
    }

    // Funkcja obliczajca pojemno pudeka.
    double Volume()
    {
      return m_Length*m_Width*m_Height;
    }

  private:
    double m_Length;                   // Dugo pudeka w centymetrach.
    double m_Width;                    // Szeroko pudeka w centymetrach.
    double m_Height;                   // Wysoko pudeka w centymetrach.

  // Funkcja zaprzyjaniona.
  friend double BoxSurface(CBox aBox);
};

// Funkcja zaprzyjaniona obliczajca pole powierzchni pudeka.
double BoxSurface(CBox aBox)
{
  return 2.0*(aBox.m_Length*aBox.m_Width +
              aBox.m_Length*aBox.m_Height +
              aBox.m_Height*aBox.m_Width);
}

int main()
{
  CBox match(2.2, 1.1, 0.5);           // Deklaracja obiektu match.
  CBox box2;                           // Deklaracja obiektu box2  brak wartoci domylnych.

  cout << endl
       << "Pojemno pudeka match = "
       << match.Volume();

  cout << endl
       << "Pole powierzchni pudeka match = "
       << BoxSurface(match);

  cout << endl
       << "Pojemno pudeka box2 = "
       << box2.Volume();

  cout << endl
       << "Pole powierzchni pudeka box2 = "
       << BoxSurface(box2);

  cout << endl;
  return 0;
}
