// Cw6_11.cpp : main project file.
// Kalkulator CLR obsugujcy nawiasy.

#include "stdafx.h"
#include <cstdlib>                          // Dla funkcji exit().

using namespace System;
String^ eatspaces(String^ str);             // Funkcja usuwajca spacje.
double expr(String^ str);                   // Funkcja obliczajca warto wyraenia.
double term(String^ str, int^ index);       // Funkcja analizujca skadnik.
double number(String^ str, int^ index);     // Funkcja rozpoznajca liczby.
String^ extract(String^ str, int^ index);   // Funkcja wydobywajca podacuchy.

int main(array<System::String ^> ^args)
{
  String^ buffer;    // Obszar wejciowy do obliczania wartoci wyrae.

   
  Console::WriteLine(L"Witaj w naszym przyjaznym kalkulatorze.");
  Console::WriteLine(L"Wprowad jakie wyraenie lub pusty wiersz, aby zakoczy.");

  for(;;)
  {
    buffer = eatspaces(Console::ReadLine());         // Wczytaj wiersz danych wejciowych.

    if(String::IsNullOrEmpty(buffer))                // Pusty wiersz koczy prac kalkulatora.
      return 0;

    Console::WriteLine(L"  = {0}\n\n",expr(buffer)); // Wylij na wyjcie warto wyraenia.
  }
  return 0;
}

// Funkcja usuwajca spacje z acucha.
String^ eatspaces(String^ str)
{
  // Tablica przechowujca acuchy bez spacji.  
  array<wchar_t>^ chars = gcnew array<wchar_t>(str->Length);
  int length = 0;                      // Liczba znakw w tablicy.

  // Skopiuj znaki nie bdce spacjami do tablicy chars.
  for each(wchar_t ch in str)
    if(ch != ' ')
      chars[length++] = ch;

  // Zwr tablic chars jako acuch.
  return gcnew String(chars, 0, length);
}

// Funkcja obliczajca warto wyraenia arytmetycznego.
double expr(String^ str)
{
  int^ index = 0;                      // ledzi pooenie biecego znaku.

  double value = term(str, index);     // Pobierz pierwszy element.

  while(*index < str->Length)
  {
    switch(str[*index])                // Wybierz dziaanie zgodne z biecym znakiem.
    {
      case '+':                        // Znaleziono znak +, 
         ++(*index);                   // a wic zwiksz wskanik index o jeden i dodaj
         value += term(str, index);    // nastpny skadnik.
         break;

      case '-':                        // Znaleziono znak -, a wic
          ++(*index);                  // zmniejsz wskanik index o jeden i dodaj
        value -= term(str, index);     // nastpny skadnik.
         break;

      default:                         // Wykonanie tego kodu oznacza, e wprowadzone wyraenie jest nieprawidowe.
        Console::WriteLine(L"Arrrgh!*#!! Tu jest bd.\n");
        exit(1);
    }
  }
  return value;
}

// Funkcja sprawdzajca warto skadnika.
double term(String^ str, int^ index)
{
  double value = number(str, index);        // Pobierz pierwsz liczb skadnika.

  // Powtarzaj dopki s znaki i waciwe operatory.
  while(*index < str->Length)
  {
    if(str[*index] == L'*')                 // Jeli znajdziesz znak mnoenia,
    {
      ++(*index);                           // zwiksz index i
      value *= number(str, index);          // pomn przez nastpn liczb.
    }
    else if( str[*index] == L'/')           // Jeli znajdziesz znak dzielenia,
    {
      ++(*index);                           // zwiksz index i
      value /= number(str, index);          // podziel przez nastpn liczb
    }
    else
      break;                                // Wyjd z ptli.
 }
  // Skoczone, a wic zwracamy co uzyskalimy.
  return value;                             
}

// Funkcja rozpoznajca liczb.
double number(String^ str, int^ index)
{
  double value = 0.0;                       // Do przechowywania wyniku.

  // Poszukiwanie wyraenia w nawiasach.
  if(str[*index] == L'(' )                  // Pocztek nawiasu.
  {
    ++(*index);
    String^ substr = extract(str, index);   // Wydobycie podacucha w nawiasach.
    return expr(substr);                    // Zwrcenie wartoci podacucha.
  }

  // Ptla zbierajca wiodce cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))
  {
    value = 10.0*value + Char::GetNumericValue(str[(*index)]);
    ++(*index);
  }

  // Znaleziono znak nie bdcy cyfr.
  if((*index == str->Length) || str[*index] != '.')   // A wic poszukujemy przecinka dziesitnego.
    return value;                                     // Jeli nie ma, zwracamy zmienn value.

  double factor = 1.0;                 // Wspczynnik dla miejsc po przecinku.
  ++(*index);                          // Przesunicie do cyfry.

  // Powtarzaj dopki s cyfry.
  while((*index < str->Length) && Char::IsDigit(str, *index))   
  {
    factor *= 0.1;                     // Zmniejsz wspczynnik  dziesiciokrotnie.
    value = value + Char::GetNumericValue(str[*index])*factor; // Dodaj miejsce po przecinku.
    ++(*index);
  }

  return value;                        // Koniec ptli - skoczone.
}

// Funkcja wydobywajca podacuch w nawiasach.
String^ extract(String^ str, int^ index)
{
  // Tymczasowe miejsce dla podacucha.
  array<wchar_t>^ buffer = gcnew array<wchar_t>(str->Length); 
  String^ substr;                      // Podacuch, ktry ma zosta zwrcony.
  int numL = 0;                        // Licznik znalezionych lewych nawiasw.
  int bufindex = *index;               // Zachowaj warto pocztkow wskanika index.

  while(*index < str->Length)
  {
    buffer[*index - bufindex] = str[*index];
    switch(str[*index])
    {
      case ')':
        if(numL == 0)
        {
          array<wchar_t>^ substrChars = gcnew array<wchar_t>(*index - bufindex);
          str->CopyTo(bufindex, substrChars, 0, substrChars->Length);
          substr = gcnew String(substrChars);
          ++(*index);

          return substr;               // Zwr acuch w nowej pamici.
        }
        else
          numL--;                      // Zmniejsz licznik znakw '(' do dopasowania.
        break;

      case '(':
        numL++;                        // Zwiksz licznik znakw '(' do dopasowania
        break;
      }
    ++(*index);
  }

  Console::WriteLine(L"Koniec wyraenia, dane wejciowe musiay by nieprawidowe.");
  exit(1);
  return substr;
}
