// PanelZInformacjamiODysku.cpp : implementation file
//

#include "stdafx.h"
//#include "DiskInfoKomponent.h"
#include "PanelZInformacjamiODysku.h"


// PanelZInformacjamiODysku

IMPLEMENT_DYNAMIC(PanelZInformacjamiODysku, CProgressCtrl)

PanelZInformacjamiODysku::PanelZInformacjamiODysku(char LiteraDysku)
	:obiektIstnieje(false)
{
	SetLiteraDysku(LiteraDysku);
}

PanelZInformacjamiODysku::~PanelZInformacjamiODysku()
{
}


BEGIN_MESSAGE_MAP(PanelZInformacjamiODysku, CProgressCtrl)
	ON_WM_PAINT()
END_MESSAGE_MAP()

void PanelZInformacjamiODysku::SetLiteraDysku(char LiteraDysku)
{
   literaDysku = LiteraDysku;
   PobierzInformacjeODysku(literaDysku, daneODysku);
   
   const int BwGB=1024*1024*1024;

   double calkowitaPrzestrzenGB = ROUND1(daneODysku.calkowitaPrzestrzen/BwGB);
   double wolnaPrzestrzenGB = ROUND1(daneODysku.wolnaPrzestrzen/BwGB);
   double zajetaPrzestrzenGB = ROUND1(daneODysku.zajetaPrzestrzen/BwGB);

   opisLewy.Format(L" %c: %s (%s)", daneODysku.literaDysku, daneODysku.nazwaDysku, daneODysku.nazwaFAT);
   opisPrawy.Format(L"%.2f/%.2f/%.2f (%d%%) ", zajetaPrzestrzenGB, wolnaPrzestrzenGB, calkowitaPrzestrzenGB, 100 - daneODysku.wolnaPrzestrzenProcenty);
   pozycjaPaska = 100 - daneODysku.wolnaPrzestrzenProcenty;
   
   if (!daneODysku.czyDyskDostepny)
   {
      opisLewy.Format(L"%c: Dysk niedostpny!",daneODysku.literaDysku);
      opisPrawy.Format(L"");
      pozycjaPaska = 100;
   }

   if(obiektIstnieje) this->SetPos(pozycjaPaska);
}

DaneODysku PanelZInformacjamiODysku::GetDaneODysku()
{
	return daneODysku;
}

char PanelZInformacjamiODysku::GetLiteraDysku()
{
	return literaDysku;
}

// PanelZInformacjamiODysku message handlers

void PanelZInformacjamiODysku::OnPaint()
{
	if(!obiektIstnieje)
	{
		obiektIstnieje=true;
		this->SetPos(pozycjaPaska);
	}

	CClientDC dc(this); //device context for painting
    CRect rc, rcUpdate, rcProgressBar;
	CRgn rgn;

    GetUpdateRect(rcUpdate);

    CProgressCtrl::OnPaint();

    rgn.CreateRectRgn(rcUpdate.left, rcUpdate.top, rcUpdate.right, rcUpdate.bottom);
    dc.SelectClipRgn(&rgn);
    GetClientRect(rc);
    dc.SetBkMode(TRANSPARENT);
	dc.SelectClipRgn(NULL);
	dc.DrawText(opisLewy, -1, rc, DT_SINGLELINE | DT_VCENTER | DT_LEFT); // lewy opis paska postpu
	dc.DrawText(opisPrawy, -1, rc, DT_SINGLELINE | DT_VCENTER | DT_RIGHT); // prawy opis paska postpu
	
	dc.SelectClipRgn(NULL);
}
