#include "Stdafx.h"

#include "CDib.h" 


CDib::CDib(const char *pFileName)
{                 
    LoadFile(pFileName);
}                     

CDib::CDib(CDC &sDC, CRect &Frame)
{           
    LoadFrame(sDC, Frame);
}

CDib::~CDib(void)
{
    if(pImage) {
        delete [] pImage;
        pImage = 0;
    }
}                            
 
void CDib::LoadFile(const char *pFileName)
{             
    CFile DibFile;
    pImage = 0;
    BOOL Success = DibFile.Open(pFileName, CFile::modeRead);         
    if(Success) {
        FileSize = DibFile.GetLength();
        pImage = new BYTE [FileSize];
        DibFile.ReadHuge(pImage, FileSize);
        DibFile.Close();
        pHead = (BITMAPFILEHEADER *)pImage;
        ASSERT(pHead->bfType == 'MB');
        pInfo = (BITMAPINFOHEADER *)
                    (pImage + sizeof(BITMAPFILEHEADER));
        pInfoQuad = (BITMAPINFO * )pInfo;                         
        pQuad = (RGBQUAD *)((BYTE *)pInfo + pInfo->biSize);
        pBits = pImage + pHead->bfOffBits;       
        Width  = int(pInfo->biWidth);
        Height = int(pInfo->biHeight);
        Skip = (Width + 3) / 4 * 4 - Width;
        BitsSize = (long(Width) + Skip) * Height;
        QuadsSize = int(pBits - (BYTE *)pInfo - 
                        sizeof(BITMAPINFOHEADER));
        NoOfColors = QuadsSize / 4;
    }                     
}                                               

void CDib::LoadFrame(CDC &sDC, CRect &Frame)
{
    Width  = Frame.right  - Frame.left;
    Height = Frame.bottom - Frame.top;  
    Skip   = (Width + 3) / 4 * 4 - Width;

    BITMAPFILEHEADER FileH;
    FileH.bfType          = 'MB';
//  FileH.bfSize          = // later
    FileH.bfReserved1     = 0;
    FileH.bfReserved2     = 0;
//  FileH.bfOffBits       = // later
    
    BITMAPINFOHEADER InfoH;
    InfoH.biSize          = sizeof(BITMAPINFOHEADER);
    InfoH.biWidth         = Width,
    InfoH.biHeight        = Height,
    InfoH.biPlanes        = 1;
    InfoH.biBitCount      = 8;
    InfoH.biCompression   = 0;
    InfoH.biSizeImage     = 0;
    InfoH.biXPelsPerMeter = 0;
    InfoH.biYPelsPerMeter = 0;
//  InfoH.biClrUsed       = // later
//  InfoH.biClrImportant  = // later
    
    QuadsSize = 256;                            // largest size
    BitsSize  = (Width + 3L) / 4 * 4 * Height; 
    
    RGBQUAD *pQuad0 = (RGBQUAD *)(new BYTE [QuadsSize]);
    BYTE *pBits0    = new BYTE [BitsSize];

    NoOfColors = CreateImage(sDC, Frame, &InfoH, pQuad0, pBits0);
    QuadsSize  = NoOfColors * sizeof(RGBQUAD);  // proper size    
    
    FileSize  = sizeof(BITMAPFILEHEADER) + 
                sizeof(BITMAPINFOHEADER) + 
                QuadsSize + BitsSize;
    pImage    =  new BYTE [FileSize];
          
    InfoH.biClrUsed      = NoOfColors;    
    InfoH.biClrImportant = NoOfColors;    
    FileH.bfOffBits = sizeof(BITMAPFILEHEADER) + 
                      sizeof(BITMAPINFOHEADER) + QuadsSize;
    FileH.bfSize    = FileSize; 
    
    BYTE *Target = pImage;
    pHead     = (BITMAPFILEHEADER *)Target;
    Target    = Copy(Target, &FileH, sizeof(BITMAPFILEHEADER));
    pInfo     = (BITMAPINFOHEADER *)Target;
    pInfoQuad = (BITMAPINFO *)Target;
    Target    = Copy(Target, &InfoH, sizeof(BITMAPINFOHEADER));
    pQuad     = (RGBQUAD *)Target;
    pBits     = Copy(Target, pQuad0, QuadsSize);
    (void)      Copy(pBits,  pBits0, BitsSize);

    if(pBits0) {
        delete [] pBits0;
        pBits0 = 0;
    }
    if(pQuad0) {
        delete [] pQuad0;
        pQuad0 = 0;
    }
} 

int CDib::CreateImage(CDC &sDC,  // src
                      CRect &Frame, BITMAPINFOHEADER  *pInfoH,
                      RGBQUAD *pQuads, BYTE *pBits)
{                                         
    CRect *pFrame = &Frame;            
    int NoOfColors = 0;                               
    COLORREF Pixel;
    long Width  = pInfoH->biWidth,
         Height = pInfoH->biHeight;
    long Skip = (Width + 3L) / 4 * 4 - Width;
    for(int h = int(Height) - 1; h >= 0 ; h--) {
        for(int w = 0; w < Width; w++) {  
            Pixel = sDC.GetPixel(w + Frame.left,
                                 h + Frame.top);
                                 
            for(int c = 0; c < NoOfColors ; c++) {
                if(RGB(pQuads[c].rgbRed,
                       pQuads[c].rgbGreen,
                       pQuads[c].rgbBlue) == Pixel)
                    break;
            }
            if(c == NoOfColors) {    
                pQuads[c].rgbBlue  = GetBValue(Pixel);
                pQuads[c].rgbGreen = GetGValue(Pixel);
                pQuads[c].rgbRed   = GetRValue(Pixel);
                pQuads[c].rgbReserved = 0;
                c = NoOfColors++;
            }                   
            *pBits++ = c;
         }                                  
         pBits += Skip;
    }
    return NoOfColors;            
} 

BYTE *CDib::Copy(BYTE *pTrg, 
                 void *pSrc, long Count)
{
    for(long i = 0; i < Count ; i++)
        pTrg[i] = ((BYTE *)pSrc)[i];
    return pTrg + Count;
}

void CDib::SaveDib(char *pFileName)
{
    CFile Out;
    BOOL Success = 
        Out.Open(pFileName,
                 CFile::modeCreate | CFile::modeWrite);
    if(Success) {
        Out.WriteHuge(pHead, sizeof(BITMAPFILEHEADER));
        Out.WriteHuge(pInfo, sizeof(BITMAPINFOHEADER));
        Out.WriteHuge(pQuad, QuadsSize); 
        Out.WriteHuge(pBits, BitsSize);
        Out.Close();                            
    }                               
}

void CDib::ShowDib(
               CDC &dDC, 
               int xDst, int yDst, 
               int wDst, int hDst,
               int xSrc, int ySrc,
               int wSrc, int hSrc,
               BYTE       *pBits,
               BITMAPINFO *pInfoQuad//,
           )
{
  ::StretchDIBits(
        dDC.GetSafeHdc(), 
        xDst, yDst,
        wDst, hDst,
        xSrc, ySrc,
        wSrc, hSrc,
        pBits,
        pInfoQuad,
        DIB_RGB_COLORS,
        SRCCOPY
    );
}
    
#if 0 // a few useful predefined types
          
typedef struct tagBITMAPFILEHEADER {
    WORD  bfType;
    DWORD bfSize;
    WORD  bfReserved1, bfReserved2;
    DWORD bfOffBits;
} BITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER {
    DWORD biSize, biWidth, biHeight;
    WORD  biPlanes, biBitCount;
    DWORD biCompression, biSizeImage,
          biXPelsPerMeter, biYPelsPerMeter,
          biClrUsed, biClrImportant;
} BITMAPINFOHEADER;

typedef struct tagRGBQUAD {
    BYTE  rgbBlue, rgbGreen, rgbRed, rgbReserved;
} RGBQUAD;

typedef struct tagBITMAPINFO {
    BITMAPINFOHEADER bmiHeader;
    RGBQUAD bmiColors[1];
} BITMAPINFO;    

typedef BITMAPINFO * LPBITMAPINFO;

#endif
