// MyView.h : interface of the CMyView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYVIEW_H__21173DEF_99B4_11D2_89E8_008048ED3B04__INCLUDED_)
#define AFX_MYVIEW_H__21173DEF_99B4_11D2_89E8_008048ED3B04__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "threads.h"

class CMyDoc;

class CMyView : public CView {
protected:
    int playTime, w, h, count, dx, dy,
        shipTop, shotLeft, shotTop,
        shotX, shotY, shipX, shipY,
        shotW, shotH, shipW, shipH;
    long startTime, gameTime;

        // liczniki trafie i czasu
    CStatic *pCounter, *pTimer;
    CDC *pDC, *pMemDC;

        // obrazy statku i pocisku
    CBitmap *pShipBitmap, *pShotBitmap;

    bool shipHit, shipDrawn, stopShip, 
         stopShot, wereShots,
         shotNotDone, gameDone,
         gameNotReady;

    CWorkerThread *pShipThread, *pShotThread;
    CSection hitLock, gameReady, shotDone, wasHit;
    CAutoEvent gameIsReady, shotIsDone;
public:
    static CMyView *pView;
    static int shotCode(void *);
    static int shipCode(void *);

    void shipRun(void);
    void shotRun(void);

    void drawImage(CBitmap *pBitmap, 
                   int x, int y, int w, int h);
    void startGame(void);
    bool shipWasHit(void);
    long currentTime(void);
    void beep(int count);
    void cleanUp(void);

// ====

protected: // create from serialization only
    CMyView(void);
    DECLARE_DYNCREATE(CMyView)

// Attributes
public:
    CMyDoc *GetDocument(void);

// Operations
public:

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CMyView)
	public:
	    virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	    virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	    virtual void OnInitialUpdate();
	protected:
	    virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	    virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	    virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMyView(void);
#ifdef _DEBUG
	virtual void AssertValid(void) const;
	virtual void Dump(CDumpContext &dc) const;
#endif

protected:

// Generated message map functions
protected:
    //{{AFX_MSG(CMyView)
        afx_msg void OnTimer(UINT nIDEvent);
        afx_msg void OnKeyUp(UINT nChar, 
                             UINT nRepCnt, UINT nFlags);
        afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
        afx_msg void OnSize(UINT nType, int cx, int cy);
        afx_msg void OnDestroy();
        afx_msg void onExit();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in MyView.cpp
inline CMyDoc *CMyView::GetDocument(void)
   { return (CMyDoc *)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MYVIEW_H__21173DEF_99B4_11D2_89E8_008048ED3B04__INCLUDED_)
