// Circle.cpp : implementation file
//

#include "stdafx.h"
#include "My.h"
#include "Circle.h"

#include "threads.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Circle

const int Circle::r = 30;
CSection Circle::moveLock;

        // funkcja moveCode musi by statyczna
int Circle::moveCode(void *pArg)
{
    Circle *pCircle = (Circle *)pArg;
    while(true) {
        moveLock.enterSection();
            pCircle->move(CMyView::getSize());
        moveLock.leaveSection();

        sleep(50);
    }
}

Circle::Circle(CPoint point) 
    : point(point), color(rand())
{
        // liczby przypadkowe +1 albo -1
    dx = ((rand() & 1) << 1) - 1;
    dy = ((rand() & 1) << 1) - 1;

         // odpalenie wtku
    pMoveThread = new CWorkerThread(moveCode, this);
}

void Circle::draw(CDC *pDC)
{
    CBrush brush(color), *pOldBrush;
    pOldBrush = pDC->SelectObject(&brush);

    moveLock.enterSection();
        int x = point.x,
            y = point.y;
    moveLock.leaveSection();

    pDC->Ellipse(x-r, y-r, x+r, y+r);
    pDC->SelectStockObject(NULL_BRUSH);
    pDC->Ellipse(x-r, y-r, x+r, y+r);
    pDC->SelectObject(pOldBrush);
}

void Circle::move(CSize size)
{
    int x = point.x + dx,
        y = point.y + dy,
        w = size.cx,
        h = size.cy;
    if(x < r || x > w-r)
        dx = - dx;
    else
        point.x += dx;;
    if(y < r || y > h-r)
        dy = -dy;
    else
        point.y += dy;
}

IMPLEMENT_DYNCREATE(Circle, CDocument)

Circle::Circle()
{
}

BOOL Circle::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

Circle::~Circle()
{
}


BEGIN_MESSAGE_MAP(Circle, CDocument)
	//{{AFX_MSG_MAP(Circle)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Circle diagnostics

#ifdef _DEBUG
void Circle::AssertValid() const
{
	CDocument::AssertValid();
}

void Circle::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// Circle serialization

void Circle::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// Circle commands
