// LinesView.cpp : implementation of the CLinesView class
//

#include "stdafx.h"
#include "Lines.h"

#include "LinesDoc.h"
#include "LinesView.h"

#include "LinesFrm.h"
#include "MyLine.h"
#include "MyRGB.h"
#include "MyList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinesView

IMPLEMENT_DYNCREATE(CLinesView, CView)

BEGIN_MESSAGE_MAP(CLinesView, CView)

	//{{AFX_MSG_MAP(CLinesView)
	ON_WM_SIZE()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_KEYUP()
	ON_COMMAND(ID_RED, OnRed)
	ON_COMMAND(ID_GREEN, OnGreen)
	ON_COMMAND(ID_BLUE, OnBlue)
	ON_COMMAND(ID_CUSTOM, OnCustom)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_ViewList, OnViewList)
	ON_WM_RBUTTONUP()
	ON_UPDATE_COMMAND_UI(ID_ViewList, OnUpdateViewList)
	//}}AFX_MSG_MAP

	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)

    // jb man.add
    ON_COMMAND(ID_QUIT, OnQuit)
    ON_MESSAGE(ID_ListClosed, OnListClosed)

END_MESSAGE_MAP()

///////////////////////////////////////////////////////////
// CLinesView construction/destruction

CLinesView::CLinesView()
{
	// TODO: add construction code here

    DownFlag = FALSE;
    LineColor = RGB(255,0,0);

    pQuit  = 0; //new CButton();
    pPress = 0; //new CStatic();
    pFont  = 0; //new CFont();
	pFont  = new CFont();
    const int Style = 1; // 0 - Regular, 1 - Italic
	pFont->CreateFont(
               36, 0, 0, 0, FW_BOLD, Style, 0, 0,
		       ANSI_CHARSET,
			   OUT_DEFAULT_PRECIS,
			   CLIP_DEFAULT_PRECIS,
			   DEFAULT_QUALITY,
			   DEFAULT_PITCH | FF_DONTCARE,
			   "Times New Roman"
           );
	pListDialog = 0;
}

CLinesView::~CLinesView()
{
    delete pQuit;
    delete pPress;
    delete pFont;

	if(pListDialog) {
		pListDialog->DestroyWindow();
	    delete pListDialog;
	}
}

CLinesFrm *CLinesView::GetFrame(void)
{
#if !defined(Multi)
    return (CLinesFrm *)GetParent();
#else
    return (CLinesFrm *)GetParent()->GetParent();
#endif
}

BOOL CLinesView::PreCreateWindow(CREATESTRUCT &cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	CWinApp *pWinApp = AfxGetApp();   
	static CBitmap Bitmap8x8;
	Bitmap8x8.LoadBitmap(IDB_MyBitmap);
	static CBrush BitmapBrush;
	BitmapBrush.CreatePatternBrush(&Bitmap8x8);

	static CString MyViewClass =             // beware of auto!
		AfxRegisterWndClass(
			/*CS_HREDRAW | CS_VREDRAW |*/ CS_DBLCLKS, // cf. OnSize
//          pWinApp->LoadStandardCursor(IDC_CROSS),
            pWinApp->LoadCursor(IDC_MyCursor),
//			(HBRUSH)::GetStockObject(LTGRAY_BRUSH),
            BitmapBrush,
//			pWinApp->LoadStandardIcon(IDI_APPLICATION)
            NULL
		);	
	cs.lpszClass = MyViewClass;

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLinesView drawing

void CLinesView::DrawRect(CDC *pDC)
{
    CRect Client, Clip;
    GetClientRect(&Client);
    pDC->GetClipBox(&Clip);
    Client.left   += 30;
    Client.top    += 3;
    Client.right  -= 3;
    Client.bottom -= 3;
    CRgn ClientRgn, ClipRgn, CommonRgn;
    ClientRgn.CreateRectRgn(Client.left, Client.top,
                            Client.right, Client.bottom);
    ClipRgn.CreateRectRgn(Clip.left, Clip.top, 
                          Clip.right, Clip.bottom);
    CommonRgn.CreateRectRgn(0, 0, 0, 0);
    CommonRgn.CombineRgn(&ClientRgn, &ClipRgn, RGN_AND);
    CClientDC cDC(this);
    cDC.SelectClipRgn(&CommonRgn);
    cDC.Rectangle(Client.left, Client.top,
                  Client.right, Client.bottom);
}

void CLinesView::OnDraw(CDC *pDC)
{
	CLinesDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here

    DrawRect(pDC);
    pPress->Invalidate();    // zgoszenie
    pPress->UpdateWindow();  // obsuga
    pDoc->DrawLines(*pDC);
    pDoc->DrawPoint(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CLinesView printing

BOOL CLinesView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CLinesView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CLinesView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CLinesView diagnostics

#ifdef _DEBUG
void CLinesView::AssertValid() const
{
	CView::AssertValid();
}

void CLinesView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CLinesDoc* CLinesView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLinesDoc)));
	return (CLinesDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLinesView message handlers

void CLinesView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
    Center = CPoint(cx/2, cy/2);
    CLinesDoc *pDoc = GetDocument();
    if(!pDoc->LinesDrawn()) 
        pDoc->SetPoint(Point = Center);
	delete pQuit;
	pQuit = new CButton();
    CRect Client, QuitRect(0, 0, 50, 20);
	GetClientRect(&Client);
	QuitRect.OffsetRect(Client.right  - QuitRect.right-5 ,
		                Client.bottom - QuitRect.bottom-5);
 	pQuit->Create("Quit",
		           WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		           QuitRect, this, ID_QUIT);
    Invalidate();  // bez tego ciekawe efekty
}

void CLinesView::OnQuit()
{
    GetFrame()->SendMessage(WM_CLOSE);
    return;
}

void CLinesView::OnLButtonDown(UINT nFlags, CPoint Point) 
{
	// TODO: Add your message handler code here 

    if(nFlags & MK_CONTROL) {
	    CView::OnLButtonDown(nFlags, Point);
        return;
    }

    CLinesFrm *pFrame = GetFrame();
    pFrame->ShowMouseAnchor(Point.x, Point.y);

    SetCapture();                      // all messages to the frame
	CRect Client;
	GetClientRect(&Client);
	ClientToScreen(&Client);
	::ClipCursor(&Client);             // cursor within frame only
	CClientDC cDC(this);	                          
	DownFlag = TRUE;
	pLine = new CMyLine(CLinesView::Point, 
					    Point, RGB(0,0,0));
	pLine->DrawLine(cDC, R2_NOT);      // draw temporary line

	CView::OnLButtonDown(nFlags, Point);
}

void CLinesView::OnMouseMove(UINT nFlags, CPoint Point) 
{
	// TODO: Add your message handler code here and/or call default
    nFlags=nFlags;
    CLinesFrm *pFrame = GetFrame();
    pFrame->ShowMouseXY(Point.x, Point.y);

	CClientDC cDC(this);
	if(DownFlag) {
		pLine->DrawLine(cDC, R2_NOT);  // clear temporary line
		pLine->SetTail(Point);               
		pLine->DrawLine(cDC, R2_NOT);  // draw temporary line
	}

	CView::OnMouseMove(nFlags, Point);
}

void CLinesView::OnLButtonUp(UINT nFlags, CPoint Point) 
{
	// TODO: Add your message handler code here and/or call default

    if(nFlags & MK_CONTROL) {
        CLinesDoc *pDoc = GetDocument();
        pDoc->SetPoint(Point);
        Invalidate();
	    CView::OnLButtonDown(nFlags, Point);
        return;
    }

	::ReleaseCapture();
	::ClipCursor(NULL);
	if(DownFlag) {
		DownFlag = FALSE;
		CClientDC cDC(this);          
		pLine->SetColor(LineColor);
		pLine->DrawLine(cDC);          // draw final line
		if(CLinesView::Point != Point) {
		    CLinesView::Point = Point;
		    CLinesDoc *pDoc = GetDocument();
		    pDoc->AddLine(pLine);          // add line to the document
		    pQuit->Invalidate();           // restore Quit
		    SetModifiedFlag();
		}
	}
	
	CView::OnLButtonUp(nFlags, Point);
}

void CLinesView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default

	if(nChar == VK_DELETE) {           // Del key
		CLinesDoc *pDoc = GetDocument();
		pDoc->DelLine(Point);          // delete line, update Anchor
		SetModifiedFlag();
		Invalidate();
	} else
		MessageBeep(MB_OK);            // other key than Del
	
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CLinesView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

   	delete pPress;
	pPress = new CStatic();
    CClientDC cDC(this);
    cDC.SelectObject(pFont);
    CString Prompt = "Press and Drag";
    CSize Size = cDC.GetTextExtent(Prompt, Prompt.GetLength());
    pPress->Create(Prompt,
		           WS_CHILD | WS_VISIBLE | SS_LEFT,
				   CRect(CPoint(10, 5), Size), this);
	pPress->SetFont(pFont);

	CLinesDoc *pDoc = GetDocument();
    static BOOL Virgin = TRUE;
    if(!Virgin) {
        pDoc->SetPoint(Point = Center);
    }
    Virgin = FALSE;
    pDoc->UpdateListBox();
}

void CLinesView::SetModifiedFlag(void)
{
	CLinesDoc *pDoc = GetDocument();
	pDoc->SetModifiedFlag();
}


void CLinesView::OnRed() 
{
	// TODO: Add your command handler code here

    LineColor = RGB(255,0,0);	
}

void CLinesView::OnGreen() 
{
	// TODO: Add your command handler code here
	
    LineColor = RGB(0,255, 0);	
}

void CLinesView::OnBlue() 
{
	// TODO: Add your command handler code here
	
    LineColor = RGB(0,0, 255);	
}

void CLinesView::OnCustom() 
{
	// TODO: Add your command handler code here
	
    CMyRGB MyRGBDialog(this);
	if(MyRGBDialog.DoModal() == IDOK)
		LineColor = MyRGBDialog.GetColor();
}

void CLinesView::OnLButtonDblClk(UINT nFlags, CPoint Point) 
{
	// TODO: Add your message handler code here and/or call default

    OnLButtonUp(nFlags, Point);
    OnKeyUp(VK_DELETE, 0, 0);
	CColorDialog Color;                // dialog window
	if(Color.DoModal() == IDOK)
		LineColor = Color.GetColor();  // set new color
	
	CView::OnLButtonDblClk(nFlags, Point);
}

LONG CLinesView::OnListClosed(UINT wParam, LONG lParam)
{
	pListDialog->DestroyWindow();
	delete pListDialog;
	pListDialog = 0;
	return 0;
}

void CLinesView::OnViewList() 
{
	// TODO: Add your command handler code here

	if(!pListDialog) {
        pListDialog = new CMyList(this);
		pListDialog->Create(IDD_MyListDialog, this);
		MoveWindow(pListDialog);
		CLinesDoc *pDoc = GetDocument();
		pDoc->UpdateListBox();
		pListDialog->ShowWindow(SW_SHOW);
		SetFocus();   // return focus to View
	} else
		MessageBeep(MB_OK);	
}

void CLinesView::MoveWindow(CMyList *pListDialog)
{
	const int ScrW = ::GetSystemMetrics(SM_CXSCREEN);
	const int ScrH = ::GetSystemMetrics(SM_CYSCREEN);
    CRect Rect;
	pListDialog->GetWindowRect(&Rect);
	int w = Rect.right  - Rect.left,
		h = Rect.bottom - Rect.top,
		x = ScrW - w,
		y = ScrH - h;
	pListDialog->MoveWindow(x-20, y-20, w, h);
}

CMyList *CLinesView::GetListDialogPtr()
{
	return pListDialog;
}

void CLinesView::OnRButtonUp(UINT nFlags, CPoint Point) 
{
	// TODO: Add your message handler code here and/or call default

    CMenu *pMenu, *pPopup;
	pMenu = new CMenu();
	pMenu->LoadMenu(IDR_PopupMenu);
	pPopup = pMenu->GetSubMenu(0);

	ClientToScreen(&Point);
	pPopup->TrackPopupMenu(TPM_CENTERALIGN | TPM_RIGHTBUTTON,
		                   Point.x, Point.y, this);
	delete pMenu;
	
	CView::OnRButtonDown(nFlags, Point);
}

void CLinesView::OnUpdateViewList(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

    BOOL ListActive = !!pListDialog;
    TRACE("ListActive:  %d", ListActive);
    pCmdUI->SetCheck(!ListActive);
    pCmdUI->Enable(!!ListActive);
}
