// LinesFrm.cpp : implementation of the CLinesFrm class
//

#include "stdafx.h"
#include "Lines.h"

#include "LinesFrm.h"

#include "LinesView.h"
#include "LinesDoc.h"

#include "SecondView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinesFrm

IMPLEMENT_DYNCREATE(CLinesFrm, CFrameWnd)

BEGIN_MESSAGE_MAP(CLinesFrm, CFrameWnd)

	//{{AFX_MSG_MAP(CLinesFrm)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(ID_ToolBar,   OnToolBar)
	ON_COMMAND(ID_StatusBar, OnStatusBar)
	ON_COMMAND(ID_DialogBar, OnDialogBar)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP

	// wstawiono rcznie
	// Abort Visible, Notify (cf. Enter)
	ON_BN_CLICKED(IDC_Abort, OnAbortClicked)
	// Enter NOT Visible, Notify, DefaultButton
    ON_BN_CLICKED(IDC_Enter, OnEnterTime)

END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
    IDS_MouseX, IDS_MouseY,  
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

static UINT MyIndicators[] =
{
	ID_SEPARATOR,           // status line indicator
    IDS_MouseX, IDS_MouseY,
};


/////////////////////////////////////////////////////////////////////////////
// CLinesFrm construction/destruction

CLinesFrm::CLinesFrm()
{
	// TODO: add member initialization code here
}

CLinesFrm::~CLinesFrm()
{
}

#if defined(Multi)
CSplitterWnd *CLinesFrm::GetPanes(void)
{
    return &MyPanes;
}
#endif

int CLinesFrm::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

    if(CreateMyOwnBars() == -1)
        return -1;

    RecalcLayout();

	return 0;
}

int CLinesFrm::CreateMyOwnBars()
{
	// create my StatusBar
	if(!MyStatusBar.Create(this,
		                   WS_CHILD | WS_VISIBLE | CBRS_TOP,
						   ID_MyStatusBar) ||
	   !MyStatusBar.SetIndicators(MyIndicators,
	                              sizeof MyIndicators / sizeof(int))) {
		TRACE("jb: Failed to create MyStatusBar\n");
		return -1;
	} else 
		MyStatusBar.SetPaneInfo(0, 0, SBPS_STRETCH, 0);

    	// create my ToolBar 
    ToolsShown = StatusShown = DialogShown = TRUE;
	if (!MyToolBar.Create(this) ||
		!MyToolBar.LoadToolBar(IDR_ToolBar)) {
		TRACE("jb: Failed to create MyToolBar\n");
		return -1;
	}
	MyToolBar.SetBarStyle(MyToolBar.GetBarStyle() |
                          CBRS_TOOLTIPS | CBRS_FLYBY | 
						  CBRS_SIZE_DYNAMIC);

         // create my DialogBar
	if(!MyDialogBar.Create(this,
		                   IDD_MyDialogBar,
						   CBRS_RIGHT,
						   ID_MyDialogBar))
    {
		TRACE("My_DialogBar creation failure\n");
		return -1;
    }

    return 0;
}

#if defined(Multi)
int Margin;
#endif

BOOL CLinesFrm::PreCreateWindow(CREATESTRUCT &cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	const int ScrW = ::GetSystemMetrics(SM_CXSCREEN);
	const int ScrH = ::GetSystemMetrics(SM_CYSCREEN);
	cs.x  = ScrW / 8;
	cs.y  = ScrH / 8;
	cs.cx = ScrW * 6 / 8;
	cs.cy = ScrH * 6 / 8;

	CWinApp *pWinApp = AfxGetApp();   
	static CString MyViewClass =             // beware of auto!
		AfxRegisterWndClass(
			CS_DBLCLKS,
                   NULL,
                   NULL,
			pWinApp->LoadIcon(IDI_FrameIcon) // ikona
		);	
	cs.lpszClass = MyViewClass;
#if defined(Multi)
    Margin = cs.x;
#endif

	return CFrameWnd::PreCreateWindow(cs);
}


/////////////////////////////////////////////////////////////////////////////
// CLinesFrm diagnostics

#ifdef _DEBUG
void CLinesFrm::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CLinesFrm::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLinesFrm message handlers

CLinesView *CLinesFrm::GetView(void)
{
#if !defined(Multi)
    return (CLinesView *)GetActiveView();
#else
    return (CLinesView *)MyPanes.GetPane(0, 0);
#endif
}

void CLinesFrm::OnClose() 
{
	// TODO: Add your message handler code here and/or call default

 	int Reply = MessageBox("Do you really want to quit?", 
		                   "Quit Box",
		                    MB_ICONQUESTION | MB_YESNO);
	if(Reply == IDNO) 
        return;

	CLinesView *pView = GetView();
	CLinesDoc  *pDoc  = pView->GetDocument();
	pDoc->CleanDoc();
	
	CFrameWnd::OnClose();
}

void CLinesFrm::OnStatusBar()
{
    CStatusBar *pStatusBar = &m_wndStatusBar;
	pStatusBar->ShowWindow(
		StatusShown ? SW_HIDE : SW_SHOW);
	RecalcLayout();
	StatusShown = !StatusShown;
}

void CLinesFrm::ShowMouseAnchor(int x, int y)
{
    CStatusBar *pStatusBar = &MyStatusBar;
    char Text[5];
	int Index = pStatusBar->CommandToIndex(IDS_MouseX);
    wsprintf(Text, "%d", x);
	pStatusBar->SetPaneText(Index, Text);

	Index = pStatusBar->CommandToIndex(IDS_MouseY);
    wsprintf(Text, "%d", y);
	pStatusBar->SetPaneText(Index, Text);
}

void CLinesFrm::ShowMouseXY(int x, int y)
{
    CStatusBar *pStatusBar = &m_wndStatusBar;
    char Text[5];
	int Index = pStatusBar->CommandToIndex(IDS_MouseX);
    wsprintf(Text, "%d", x);
	pStatusBar->SetPaneText(Index, Text);

	Index = pStatusBar->CommandToIndex(IDS_MouseY);
    wsprintf(Text, "%d", y);
	pStatusBar->SetPaneText(Index, Text);
}

void CLinesFrm::OnToolBar()
{
	CToolBar *pToolBar = &m_wndToolBar;
	pToolBar->ShowWindow(
		ToolsShown ? SW_HIDE : SW_SHOW);
	RecalcLayout();
	ToolsShown = !ToolsShown;
}

void CLinesFrm::OnDialogBar()
{
	CWnd *pDialogBar = &MyDialogBar;
	pDialogBar->ShowWindow(
		DialogShown ? SW_HIDE : SW_SHOW);
	RecalcLayout();
	DialogShown = !DialogShown;
}

void CLinesFrm::OnEnterTime(void)
{
    int Minutes = MyDialogBar.GetDlgItemInt(IDC_Time); 
	CScrollBar *pScroll = (CScrollBar *)MyDialogBar.GetDlgItem(IDC_Scroll);
	pScroll->SetScrollRange(0, Minutes * 60 * 10, TRUE);
	KillTimer(IDT_Timer);
    SetTimer(IDT_Timer, 100, NULL);
}

void CLinesFrm::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	ASSERT(nIDEvent == IDT_Timer);
	CScrollBar *pScroll = (CScrollBar *)MyDialogBar.GetDlgItem(IDC_Scroll);
	int Pos = pScroll->GetScrollPos();
	int Min, Max;
	pScroll->GetScrollRange(&Min, &Max);
	if(Pos < Max)
	    pScroll->SetScrollPos(++Pos);
	else {
		OnAbortClicked();
		return;
	}
    
	CFrameWnd::OnTimer(nIDEvent);
}

void CLinesFrm::OnAbortClicked()
{
	KillTimer(IDT_Timer);
    CLinesView *pView = GetView();
	CLinesDoc *pDoc = pView->GetDocument();
	pDoc->SetModifiedFlag(FALSE);

	CFrameWnd::OnClose();
}

BOOL CLinesFrm::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
#if defined(Multi)
    CRect Client;
    GetClientRect(&Client);                                
    const int w = Client.right;
    const int h = Client.bottom;  
    return MyPanes.CreateStatic(this, 2, 1) &&
           MyPanes.CreateView(0, 0, RUNTIME_CLASS(CLinesView), 
                              CSize(w, Margin), pContext) &&                         
           MyPanes.CreateView(1, 0, RUNTIME_CLASS(CSecondView),
                              CSize(w, 1), pContext); 
#endif
	return CFrameWnd::OnCreateClient(lpcs, pContext);
}

