// LinesDoc.h : interface of the CLinesDoc class
//
/////////////////////////////////////////////////////////////////////////////

class CMyLine;
class CLinesView;

class CLinesDoc : public CDocument {
protected: // create from serialization only
	CLinesDoc();

	DECLARE_SERIAL(CLinesDoc)

// Attributes
public:
private:
	CObList Lines;
    CPoint Point;

// Operations
public:	
    CLinesView *GetView(void);
    BOOL LinesDrawn(void);
	void SetPoint(CPoint);
    void DrawPoint(CDC *);
	void CleanDoc(void);
	void DrawLines(CDC &);
	void AddLine(CMyLine *);
	void DelLine(CPoint &);
	BOOL NotEmpty(void); 
	CPoint GetLastPoint(void);

    void UpdateListBox();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLinesDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CLinesDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CLinesDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

