// LinesDoc.cpp : implementation of the CLinesDoc class
//

#include "stdafx.h"
#include "Lines.h"

#include "LinesDoc.h"

#include "MyLine.h"
#include "MyList.h"
#include "LinesFrm.h"
#include "LinesView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLinesDoc

IMPLEMENT_SERIAL(CLinesDoc, CDocument, 1)

BEGIN_MESSAGE_MAP(CLinesDoc, CDocument)
	//{{AFX_MSG_MAP(CLinesDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLinesDoc construction/destruction

CLinesDoc::CLinesDoc()
{
	// TODO: add one-time construction code here
}

CLinesDoc::~CLinesDoc()
{
}

BOOL CLinesDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CLinesDoc serialization

void CLinesDoc::Serialize(CArchive& ar)
{
	Lines.Serialize(ar);
	if (ar.IsStoring())
	{
		// TODO: add storing code here
		ar << Point.x << Point.y;
	}
	else
	{
		// TODO: add loading code here
		ar >> Point.x >> Point.y;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CLinesDoc diagnostics

#ifdef _DEBUG
void CLinesDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CLinesDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLinesDoc commands

CLinesView *CLinesDoc::GetView(void)
{
    CLinesFrm *pFrame = (CLinesFrm *)AfxGetMainWnd();
#if !defined(Multi)
    return (CLinesView *)pFrame->GetActiveView();
#else
    CWnd *pWnd = pFrame->GetPanes()->GetPane(0, 0);
    return (CLinesView *)pWnd;
#endif
}

BOOL CLinesDoc::LinesDrawn(void)
{
    return !Lines.IsEmpty();
}

void CLinesDoc::SetPoint(CPoint Point)
{
	this->Point = Point;
}

void CLinesDoc::DrawPoint(CDC *pDC)
{
    pDC->SetPixel(Point.x, Point.y, RGB(0,0,0));
    pDC->SelectStockObject(NULL_BRUSH);
    pDC->Ellipse(Point.x-10, Point.y-10,
                Point.x+10, Point.y+10);
}

void CLinesDoc::CleanDoc(void)
{   
	if(!Lines.IsEmpty()){
		POSITION Pos = Lines.GetHeadPosition();
		while(Pos)
			delete (CMyLine *)Lines.GetNext(Pos); 
		Lines.RemoveAll();   // remove hanging pointers
	} 
}

void CLinesDoc::DrawLines(CDC &cDC)
{
	if(!Lines.IsEmpty()){
		POSITION Pos = Lines.GetHeadPosition();
		while(Pos){
			((CMyLine *)Lines.GetAt(Pos))->DrawLine(cDC);
			Lines.GetNext(Pos); 
		}
	} 	 
}

void CLinesDoc::AddLine(CMyLine *pLine)
{            
	Lines.AddTail(pLine);              // add line at the tail
	UpdateListBox();
}

void CLinesDoc::DelLine(CPoint &Point)
{
	if(!Lines.IsEmpty()){               // remove the last line
		CMyLine *pLine;
		pLine = (CMyLine *)Lines.RemoveTail();
		Point = pLine->GetHead();            
		delete pLine;
		UpdateListBox();
	} else
		MessageBeep(MB_OK);
}

BOOL CLinesDoc::NotEmpty(void)
{
	return !Lines.IsEmpty();
}

CPoint CLinesDoc::GetLastPoint(void)
{
    CMyLine *pLine;
	pLine = (CMyLine *)Lines.GetTail();
	return pLine->GetTail();            
}

void CLinesDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class

	CleanDoc();
	
	CDocument::DeleteContents();
}

void CLinesDoc::UpdateListBox()
{
	CLinesView *pView = GetView();
	CMyList *pListDialog = pView->GetListDialogPtr();
	if(!pListDialog)
		return;
	CListBox *pListBox = 
		(CListBox *)pListDialog->GetDlgItem(IDC_MyListBox);
	char Line[30];
	pListBox->SetTabStops(4); // 4 * 1/4 dialog base width
	pListBox->ResetContent();
	if(!Lines.IsEmpty()){
		POSITION Pos = Lines.GetHeadPosition();
		while(Pos){
			CMyLine *pLine = (CMyLine *)Lines.GetAt(Pos);
			CPoint aPoint, zPoint;
			pLine->GetLine(aPoint, zPoint);
	        wsprintf(Line, "(%d,\t%d)\t-\t(%d,\t%d)",
				     aPoint.x, aPoint.y,
                     zPoint.x, zPoint.y);
	        pListBox->AddString(Line);
			Lines.GetNext(Pos); 
		}
	}
}
