// MyDialog.cpp : implementation file
//

#include "stdafx.h"
#include "My.h"
#include "MyDialog.h"

#include <stdlib.h>       // jb

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// MyDialog dialog


MyDialog::MyDialog(CWnd* pParent /*=NULL*/)
	: CDialog(MyDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(MyDialog)
	m_Show = TRUE;
	m_RGB = -1;
	m_Edit = _T("");
	//}}AFX_DATA_INIT
    color = RGB(255,255,255);
}

void MyDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(MyDialog)
	DDX_Check(pDX, IDC_Show, m_Show);
	DDX_Radio(pDX, IDC_Red, m_RGB);
	DDX_Text(pDX, IDC_Edit, m_Edit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(MyDialog, CDialog)
	//{{AFX_MSG_MAP(MyDialog)
	ON_BN_CLICKED(IDC_Show, OnShow)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_Red, OnRed)
	ON_BN_CLICKED(IDC_Green, OnGreen)
	ON_BN_CLICKED(IDC_Blue, OnBlue)
	ON_EN_SETFOCUS(IDC_Edit, OnSetfocusEdit)
	ON_BN_CLICKED(IDC_Send, OnSend)
	ON_LBN_DBLCLK(IDC_List, OnDblclkList)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void MyDialog::showColor(void)
{
#if 1
    CWnd *pWnd = GetDlgItem(IDC_Color);
	CDC *pDC = pWnd->GetDC();
    pWnd->Invalidate();
    pWnd->UpdateWindow();
    CBrush MyBrush(color);
    pDC->SelectObject(&MyBrush);
    pDC->Rectangle(0, 0, 50, 120);
    pWnd->ReleaseDC(pDC);
#endif
}

/////////////////////////////////////////////////////////////////////////////
// MyDialog message handlers

void MyDialog::OnShow() 
{
	// TODO: Add your control notification handler code here
    CButton *pShow = (CButton *)GetDlgItem(IDC_Show);
    int state = pShow->GetCheck();
    if(state == 1) {
        GetDlgItem(IDC_Color)->ShowWindow(SW_SHOW);
        showColor();
    }
    if(state == 0)
        GetDlgItem(IDC_Color)->ShowWindow(SW_HIDE);
}

void MyDialog::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	OnShow();    // jb

	// Do not call CDialog::OnPaint() for painting messages
}

void MyDialog::OnRed() 
{
	// TODO: Add your control notification handler code here
    color = RGB(255,0,0);	
    showColor();
}

void MyDialog::OnGreen() 
{
	// TODO: Add your control notification handler code here
    color = RGB(0,255,0);		
    showColor();
}

void MyDialog::OnBlue() 
{
	// TODO: Add your control notification handler code here
    color = RGB(0,0,255);			
    showColor();
}

void MyDialog::OnSetfocusEdit() 
{
	// TODO: Add your control notification handler code here
    CListBox *pList = (CListBox *)GetDlgItem(IDC_List);
    pList->ResetContent();	

    CScrollBar *pScroll = 
        (CScrollBar *)GetDlgItem(IDC_Scroll);
    pScroll->SetScrollRange(0, 3000);
    pScroll->SetScrollPos(0);

    KillTimer(1);
    SetTimer(1, 100, 0);
}

void MyDialog::OnSend() 
{
	// TODO: Add your control notification handler code here
    CListBox *pList = (CListBox *)GetDlgItem(IDC_List);
    CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit);
    CString text;
    pEdit->GetWindowText(text);
    if(text.GetLength()) {
        pList->InsertString(pList->GetCount(), text);	
        pEdit->SetWindowText("");
    }
    //OnSetfocusEdit();
}

void MyDialog::OnDblclkList() 
{
	// TODO: Add your control notification handler code here
    CListBox *pList = (CListBox *)GetDlgItem(IDC_List);
    int pos = pList->GetCurSel(),
	    len = pList->GetTextLen(pos);
    char *pItem = new char [len+1];
    pList->GetText(pos, pItem);
    CEdit *pEdit = (CEdit *)GetDlgItem(IDC_Edit);
    pEdit->SetWindowText(pItem);
    delete [] pItem;
}

void MyDialog::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
    CScrollBar *pScroll = 
        (CScrollBar *)GetDlgItem(IDC_Scroll);
    int pos = pScroll->GetScrollPos();
    int min, max;
    pScroll->GetScrollRange(&min, &max);
    if(pos < max)
        pScroll->SetScrollPos(pos += 10);
    else
        OnSetfocusEdit();
	
	CDialog::OnTimer(nIDEvent);
}
