#if !defined(AFX_CIRCLE_H__F71D7BAD_94BD_11D2_89E8_008048ED3B04__INCLUDED_)
#define AFX_CIRCLE_H__F71D7BAD_94BD_11D2_89E8_008048ED3B04__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Circle.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// Circle document

class Circle : public CDocument
{
public:
    static const int r;
private:
    CPoint point;
    COLORREF color;
    int dx, dy;
public:
    Circle(CPoint point) 
        : point(point), color(rand())
    {
            // liczby przypadkowe +1 albo -1
        dx = ((rand() & 1) << 1) - 1;
        dy = ((rand() & 1) << 1) - 1;
    }
    void draw(CDC *pDC)
    {
        CBrush brush(color), *pOldBrush;
        pOldBrush = pDC->SelectObject(&brush);
        int x = point.x,
            y = point.y;
        pDC->Ellipse(x-r, y-r, x+r, y+r);
        pDC->SelectStockObject(NULL_BRUSH);
        pDC->Ellipse(x-r, y-r, x+r, y+r);
        pDC->SelectObject(pOldBrush);
    }
    void move(int w, int h)
    {
        int x = point.x + dx,
            y = point.y + dy;
        if(x < r || x > w-r)
            dx = - dx;
        else
            point.x += dx;;
        if(y < r || y > h-r)
            dy = -dy;
        else
            point.y += dy;
    }

protected:
	Circle();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(Circle)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(Circle)
	public:
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
	protected:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~Circle();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(Circle)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CIRCLE_H__F71D7BAD_94BD_11D2_89E8_008048ED3B04__INCLUDED_)
