// MyView.cpp : implementation of the CMyView class
//

#include "stdafx.h"
#include "My.h"

#include "MyDoc.h"
#include "MyView.h"

#include "MainFrm.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/timeb.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyView

void CMyView::drawImage(CBitmap *pBitmap, 
                        int x, int y, int w, int h)
{
    CDC mDC;
    CClientDC cDC(this);
    mDC.CreateCompatibleDC(&cDC);

    CBitmap *pOldBitmap = mDC.SelectObject(pBitmap);
    cDC.BitBlt(x, y, w, h, &mDC, 0, 0, SRCCOPY);
    mDC.SelectObject(pOldBitmap);
}


// =============================================== Statek

int CMyView::shipCode(void *)
{
    pView->shipRun();

    return 0;
}

void CMyView::shipRun(void)
{
        // czeka na gotowo gry
    gameReady.enterSection();
        if(gameNotReady)
            gameIsReady.wait(gameReady);
    gameReady.leaveSection();

    while(true) {
            // koczy na danie
        if(stopShip) 
            break;

        int rnd = rand() % 5;
        shipX = -shipW;
        shipY = (int)(shipTop * (1 - rnd/32.));

             // czeka na zniknicie pocisku
        shotDone.enterSection();
            while(shotNotDone)
                shotIsDone.wait(shotDone);
        shotDone.leaveSection();

        shipHit = false;
        shipDrawn = true;
        for(int i = 1; i < w+shipW ; i++) {
                // reguluje szybko
            sleep(10 + rnd);

                // przesuwa statek
            shipX++;

            wasHit.enterSection();
                if(shipWasHit()) {
                    wasHit.leaveSection();
                    break;
                }
            wasHit.leaveSection();    

                // wykrela statek
            drawImage(pShipBitmap, 
                      shipX, shipY, shipW, shipH);
        }
        shipDrawn = false;   
    }
}


// =============================================== Pocisk

int CMyView::shotCode(void *)
{
    pView->shotRun();

    return 0;
}

void CMyView::shotRun(void)
{
    shotNotDone = true;
    shotX = shotLeft;
    shotY = shotTop;

    for(int i = 1; i < h+shotH+1 ; i++) {
            // zatrzymuje pocisk
        if(stopShot)
            break;

            // okrela szybko
        sleep(10);

            // przesuwa pocisk
        shotY--;

        wasHit.enterSection();
            if(shipWasHit()) {
                wasHit.leaveSection();
                break;
            }
        wasHit.leaveSection();    

            // odtwarza wyrzutni
        CClientDC cDC(this);
        cDC.MoveTo(shotLeft + shotW/2, h);
        cDC.LineTo(shotLeft + shotW/2, h-3);

            // wykrela pocisk
        drawImage(pShotBitmap, 
                  shotX, shotY, shotW, shotH);
    }

        // informuje o znikniciu pocisku
    shotDone.enterSection();
        shotIsDone.notify();
        shotNotDone = false;
    shotDone.leaveSection();
}

IMPLEMENT_DYNCREATE(CMyView, CView)

BEGIN_MESSAGE_MAP(CMyView, CView)
    //{{AFX_MSG_MAP(CMyView)
	    ON_WM_TIMER()
        ON_WM_KEYUP()
        ON_WM_LBUTTONUP()
        ON_WM_SIZE()
        ON_WM_DESTROY()
        ON_COMMAND(ID_Exit, onExit)
	//}}AFX_MSG_MAP
	// Standard printing commands
        ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
        ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
        ON_COMMAND(ID_FILE_PRINT_PREVIEW, 
                   CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyView construction/destruction

CMyView *CMyView::pView;

CMyView::CMyView(void) : gameIsReady(false)
{
    // TODO: add construction code here
}

CMyView::~CMyView(void)
{
}

BOOL CMyView::PreCreateWindow(CREATESTRUCT &cs)
{
    // TODO: Modify the Window class or styles here by modifying
    //  the CREATESTRUCT cs

    return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMyView drawing

void CMyView::OnDraw(CDC *pDC)
{
    CMyDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here

// === dobiera pooenie i rozmiary
#if 1
    static int resized = false;
    if(!resized) {
        resized = true;
        const int x=250, y=250, width=600, height=400;
        CRect fRect;
        CMainFrame *pFrame = (CMainFrame *)AfxGetMainWnd();
        pFrame->GetWindowRect(&fRect);
        static int fw = (fRect.right  - fRect.left),
                   fh = (fRect.bottom - fRect.top);
            // wywoa OnSize
        pFrame->MoveWindow(x, y, 
                           fw += width-w, fh += height-h);
    }
#endif
// ===
            // wykrela wyrzutni
    pDC->MoveTo(shotLeft + shotW/2, h);
    pDC->LineTo(shotLeft + shotW/2, h-3);

    static bool wasHere = false;
    if(!wasHere) {
        wasHere = true;

        delete pCounter;
        pCounter = new CStatic();
        pCounter->Create("Counter", 
                         WS_CHILD | WS_VISIBLE,
                         CRect(0, 0, 40, 20), 
                         this, ID_Counter);
        delete pTimer;
        pTimer = new CStatic();
        pTimer->Create("Timer", 
                       WS_CHILD | WS_VISIBLE,
                       CRect(w-40, 0, w, 20), 
                       this, ID_Timer);

        pShipThread = new CWorkerThread(shipCode);

        startGame();
    }
}

/////////////////////////////////////////////////////////////////////////////
// CMyView printing

BOOL CMyView::OnPreparePrinting(CPrintInfo *pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMyView::OnBeginPrinting(CDC *, CPrintInfo *)
{
    // TODO: add extra initialization before printing
}

void CMyView::OnEndPrinting(CDC *, CPrintInfo *)
{
    // TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMyView diagnostics

#ifdef _DEBUG
void CMyView::AssertValid(void) const
{
	CView::AssertValid();
}

void CMyView::Dump(CDumpContext &dc) const
{
	CView::Dump(dc);
}

CMyDoc *CMyView::GetDocument(void) 
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMyDoc)));
	return (CMyDoc *)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyView message handlers

void CMyView::beep(int count)
{
    MessageBeep(0);
    if(count > 1) {
        Sleep(600);
        MessageBeep(0);
    }
}

bool CMyView::shipWasHit(void)
{
    dx = (shipX + shipW/2) - (shotX + shotW/2);
    dy = (shipY + shipH/2) - (shotY + shotH/2);
    if(shotNotDone && (dx * dx + dy * dy) < 100) {
        if(!shipHit) {
            beep(1);  // statek trafiony
            CWnd *pWnd = GetDlgItem(ID_Counter);
            char counter[4];
            wsprintf(counter, "%d", ++count);
            pWnd->SetWindowText(counter);
        }
        shipHit = true;

            // czyci pulpit
        Invalidate();
        UpdateWindow();
    }
    return shipHit;
}


// =============================================== Zegar

long CMyView::currentTime(void)
{
    _timeb clock;
    _ftime(&clock);

    return clock.time * 1000 + clock.millitm;
}

void CMyView::OnTimer(UINT nIDEvent) 
{
    // TODO: Add your message handler code here

    CWnd *pWnd;
    long time = currentTime();
    gameTime = time - startTime;
    pWnd = GetDlgItem(ID_Timer);
    char timer[4];
    wsprintf(timer, "%d", (500 + gameTime) / 1000);
    pWnd->SetWindowText(timer);
    if(gameTime > playTime * 1000) {
        gameDone = true;
        pWnd->SetWindowText("Done!");
    }

    CView::OnTimer(nIDEvent);
}

void CMyView::OnInitialUpdate(void) 
{
    CView::OnInitialUpdate();

    // TODO: Add your specialized code here

    playTime = 30; 

    pView    = this;
    pDC      = 0;
    pMemDC   = 0;
    pCounter = 0;
    pTimer   = 0;
    
    gameDone     = true;
    gameNotReady = true;
    stopShip     = false;
    stopShot     = false;
    wereShots    = false;

    pShotThread = 0;
    pShipThread = 0;

        // load bitmaps
    BITMAP map;
    pShipBitmap = new CBitmap();
    pShipBitmap->LoadBitmap(IDB_Ship);
    pShipBitmap->GetObject(int(sizeof(BITMAP)), &map);
    shipW = map.bmWidth;
    shipH = map.bmHeight;

    pShotBitmap = new CBitmap();
    pShotBitmap->LoadBitmap(IDB_Shot);
    pShotBitmap->GetObject(int(sizeof(BITMAP)), &map);
    shotW = map.bmWidth;
    shotH = map.bmHeight;
}

void CMyView::startGame(void)
{
    count = 0;
    CWnd *pWnd = GetDlgItem(ID_Counter);
    pWnd->SetWindowText("0");
    pWnd = GetDlgItem(ID_Timer);
    pWnd->SetWindowText("0");

    shotNotDone = false;
    gameDone = false;

        // informuje o gotowoci do gry
    gameReady.enterSection();
        gameNotReady = false;
        gameIsReady.notify();
    gameReady.leaveSection();
    
    startTime = currentTime();

    KillTimer(ID_Timer);
    SetTimer(ID_Timer, 1000, 0);
}

void CMyView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here

    if(!gameDone && !shotNotDone && shipDrawn) {
        delete pShotThread;
        if(!stopShot) {
            pShotThread = new CWorkerThread(shotCode);
            wereShots = true;
        }
    } else
        beep(2);
	
    CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CMyView::OnLButtonUp(UINT nFlags, CPoint point) 
{
    // TODO: Add your message handler code here

    if(gameDone) {
        Invalidate();
        startGame();
    }
	
    CView::OnLButtonUp(nFlags, point);
}

void CMyView::cleanUp(void)
{
        // czeka na zatrzymanie statku
    stopShip = true;
    pShipThread->waitForThread();

        // czeka na zatrzymanie pocisku
    stopShot = true;
    if(wereShots)
        pShotThread->waitForThread();

        // pozbywa si bitmap
    pShipBitmap->DeleteObject();
    delete pShipBitmap;
    pShotBitmap->DeleteObject();
    delete pShotBitmap;

    KillTimer(ID_Timer);
    delete pShotThread;
    delete pShipThread;

    delete pCounter;
    delete pTimer;
}

void CMyView::OnDestroy(void) 
{
    CView::OnDestroy();
	
    // TODO: Add your message handler code here

        // zakoczenie
    cleanUp();
}	

void CMyView::OnSize(UINT nType, int cx, int cy) 
{
    CView::OnSize(nType, cx, cy);
	
    // TODO: Add your message handler code here

    w = cx;
    h = cy;	

    shipTop  = h / 5;
    shotTop  = h;
    shotLeft = 4 * w / 5;
}

void CMyView::onExit(void) 
{
        // TODO: Add your command handler code here

        // wywoa OnDestroy
    CMainFrame *pFrame = (CMainFrame *)AfxGetMainWnd();
    pFrame->SendMessage(WM_CLOSE);   
}
