// SecondView.cpp : implementation file
//

#include "stdafx.h"
#include "lines.h"
#include "SecondView.h"

#include "LinesView.h"
#include "LinesFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSecondView

IMPLEMENT_DYNCREATE(CSecondView, CView)

CSecondView::CSecondView()
{
    MouseDown = FALSE;
    pClear = 0;
}

CSecondView::~CSecondView()
{
    delete pClear;
}


BEGIN_MESSAGE_MAP(CSecondView, CView)
	//{{AFX_MSG_MAP(CSecondView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_SIZE()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP

    ON_COMMAND(ID_Clear, OnClear)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSecondView drawing

void CSecondView::OnClear(void)
{
    Invalidate();
}

void CSecondView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CSecondView diagnostics

#ifdef _DEBUG
void CSecondView::AssertValid() const
{
	CView::AssertValid();
}

void CSecondView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSecondView message handlers

void CSecondView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

    MouseDown = TRUE;
    xOld = point.x;
    yOld = point.y;
	
	CView::OnLButtonDown(nFlags, point);
}

void CSecondView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

    if(MouseDown) {
        CClientDC cDC(this);
        cDC.MoveTo(xOld, yOld);
        cDC.LineTo(point.x, point.y);
        xOld = point.x;
        yOld = point.y;
    }
	
	CView::OnMouseMove(nFlags, point);
}

void CSecondView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

    MouseDown = FALSE;
	
	CView::OnLButtonUp(nFlags, point);
}

void CSecondView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

    delete pClear;
    pClear = new CButton();
    CRect ClearRect(0, 0, 50, 20);
 	pClear->Create("Clear",
		           WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		           ClearRect, this, ID_Clear);	
}

void CSecondView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

    CClientDC cDC(this);
    int x = point.x, 
        y = point.y;

    CFrameWnd *pFrame = (CFrameWnd *)AfxGetMainWnd();
    CSplitterWnd *pPanes = ((CLinesFrm *)pFrame)->GetPanes();
    CLinesView *pView = (CLinesView *)pPanes->GetPane(0,0);

    COLORREF Color = pView->GetColor();
    CPen   Pen(PS_SOLID, 1, Color), 
           *pOldPen;
    CBrush Brush(COLORREF(~Color & 0xffffff)),
           *pOldBrush;
    pOldPen   = cDC.SelectObject(&Pen);
    pOldBrush = cDC.SelectObject(&Brush);

    cDC.Ellipse(x-10, y-10, x+10, y+10);

    cDC.SelectObject(pOldBrush);
    cDC.SelectObject(pOldPen);
	
	CView::OnRButtonUp(nFlags, point);
}
