// myview.cpp : implementation of the CMyView class
//

#include "stdafx.h"
#include "my.h"

#include "mydoc.h"
#include "myview.h"

#include "myedit.h"
#include "mystring.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyView

IMPLEMENT_DYNCREATE(CMyView, CScrollView)

BEGIN_MESSAGE_MAP(CMyView, CScrollView)
    //{{AFX_MSG_MAP(CMyView)
    ON_COMMAND(ID_EditCmd, OnEditCmd)
    ON_WM_LBUTTONDOWN()
    ON_WM_SIZE()
    ON_WM_LBUTTONDBLCLK()
    ON_WM_KEYUP()
    ON_WM_RBUTTONUP()
    ON_WM_RBUTTONDOWN()
    ON_WM_MOUSEMOVE()
    //}}AFX_MSG_MAP
    ON_MESSAGE(ID_EditMsg, OnEditMsg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyView construction/destruction

CMyView::CMyView()
{
    // TODO: add construction code here
    
    pEditDlg = NULL;
    pTheStr = NULL;
    GrabFlag = FALSE;
    Cursor = AfxGetApp()->LoadStandardCursor(IDC_CROSS);
}

CMyView::~CMyView()
{
//  if(pEditDlg)                           // jb: ?delete null
        delete pEditDlg;
}

BOOL CMyView::PreCreateWindow(CREATESTRUCT &Cs)
{
  MyWndClass = AfxRegisterWndClass(
                 CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
                 (HCURSOR)0,   // No cursor 
                 (HBRUSH)::GetStockObject(WHITE_BRUSH),
                 (HICON)0      // No icon
               );
  Cs.lpszClass = MyWndClass;         // beware of automatic!
  return CView::PreCreateWindow(Cs);
} 

/////////////////////////////////////////////////////////////////////////////
// CMyView drawing

void CMyView::OnDraw(CDC* pDC)
{
    CMyDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here  
    
    CObList &MyList = pDoc->MyList;
    if(!MyList.IsEmpty()){
        POSITION Pos = MyList.GetHeadPosition();
        while(Pos)
            ((CMyString *)MyList.GetNext(Pos))->Draw(*pDC);
    }                              

    CMyApp *pApp = (CMyApp *)AfxGetApp();   
    pDC->DrawIcon(0, 0, pApp->hTrashCan);      // draw trash can
    
    if(pTheStr){
        pTheStr->Draw(*pDC);
        pTheStr->DrawDottedRect(*pDC);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CMyView message handlers

void CMyView::OnEditCmd(void)
{
    // TODO: Add your command handler code here
    
    if(!pEditDlg)
        (pEditDlg = new CMyEdit(this, ""))->Create();
}
                           
LONG CMyView::OnEditMsg(UINT wParam, LONG)
{
    switch(wParam){
        case EditClosed:
            pEditDlg = NULL;              // no break!
            break;
        case CleanView:
            CMyDoc *pDoc = GetDocument();
            pDoc->DeleteContents();
            Invalidate();
    }
    return 0;                    
}

void CMyView::OnLButtonDown(UINT Flags, CPoint Point)
{
    // TODO: Add your message handler here and/or call default
                          
    CClientDC cDC(this);          
    CMyDoc *pDoc = GetDocument();                  
    if(pEditDlg){                                     
        CMyString *pNewStr = 
            new CMyString(this, 
                          Point, pEditDlg->GetStr());
        if(pDoc->InsideDoc(pNewStr)){
            pDoc->InsertAtTail(pNewStr); 
            InvalidateRect(&pNewStr->GetRect());
        } else {
            pNewStr->Draw(cDC, TRUE);     // draw in red
            delete pNewStr;
        }
            
    } else {
        if(pTheStr){
            InvalidateRect(&pTheStr->GetRect());   // remove dots 
            pTheStr = NULL;
            UpdateWindow();
        }
        pTheStr = pDoc->SelectTheStr(Point);
        if(pTheStr)
            InvalidateRect(&pTheStr->GetRect());   // display dots
    }   
    
    CView::OnLButtonDown(Flags, Point);
}

void CMyView::OnSize(UINT nType, int cx, int cy)
{
    CView::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler here
    
    CMyDoc *pDoc = GetDocument();
    pDoc->UpdateDocSize(cx, cy);
}

void CMyView::OnUpdate(CView *, LPARAM, CObject *)
{                                
    CMyDoc *pDoc = GetDocument();
    SetScrollSizes(MM_TEXT, CSize(pDoc->MyDocW, pDoc->MyDocH));
    Invalidate();                      
}

void CMyView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler here and/or call default
    
    if(pTheStr){
        CMyDoc *pDoc = GetDocument();
        InvalidateRect(&pTheStr->GetRect());
        pDoc->DeleteTheStr();
    }

    CView::OnLButtonDblClk(nFlags, point);
}

void CMyView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler here and/or call default  
            
    CMyDoc *pDoc = GetDocument();
    if(!pTheStr)
        MessageBeep(MB_OK);
    else { 
        InvalidateRect(&pTheStr->GetRect());
        switch(nChar){
            case VK_DELETE:
                pDoc->DeleteTheStr();
                break;
            case VK_INSERT:
                break;                  
            default:
                MessageBeep(MB_OK);
        }
    }
    
    CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CMyView::OnRButtonDown(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler here and/or call default
                 
    CMyDoc *pDoc = GetDocument();
    if(GrabFlag = !!(pTheStr = pDoc->SelectTheStr(Point))){
        CRect Client;
        GetClientRect(&Client);
        ClientToScreen(&Client);
        CMyView::SetCapture();                        
        ::ClipCursor(&Client);           
        pTmpStr= new CMyString(*pTheStr);
        CClientDC cDC(this);
        pTmpStr->SetHotSpot(Point);
        pTmpStr->DrawDottedRect(cDC);
    } else
        MessageBeep(MB_OK);
    
    CView::OnRButtonDown(nFlags, Point);
}

void CMyView::OnMouseMove(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here and/or call default

    ::SetCursor(Cursor);
    if(GrabFlag){
        CClientDC cDC(this);
        pTmpStr->Draw(cDC, Point);
    }
    
    CView::OnMouseMove(nFlags, Point);
}

void CMyView::OnRButtonUp(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here and/or call default
    
    if(GrabFlag){   
        GrabFlag = FALSE;
        ::ClipCursor(NULL);
        ::ReleaseCapture();
        CClientDC cDC(this);
        pTmpStr->DrawDottedRect(cDC);
        delete pTmpStr;
        CRect Icon(0, 0, 32, 32);
        if(Icon.PtInRect(Point)){
            CMyDoc *pDoc = GetDocument();
            InvalidateRect(&pTheStr->GetRect());
            pDoc->DeleteTheStr();           
        }
    }
            
    CView::OnRButtonUp(nFlags, Point);
}
