// MyView.h : interface of the CMyView class
//
/////////////////////////////////////////////////////////////////////////////

class CMyView : public CView {                                    
public:
    BOOL DoTurn, DoMove;
private:                                      
    int Rad;
    CPoint Center, Current;
    int Count, Width, Height, L, T, R, B, dx, dy;
    CRect Frame, PrevFrame, Client;    
    int FrameWidth, FrameHeight,
        ClientWidth, ClientHeight,
        Pos, LeftPos;
    BOOL Launched, ClientShown, UserReSize, LeftMouse, RightMouse;
    CDC *pBackDC, *pSaveDC, *pWorkDC;
    CBitmap *pBackMap, *pSaveMap, *pWorkMap,
            *pOldBack, *pOldSave, *pOldWork;

protected: // create from serialization only
    CMyView(void);
    DECLARE_DYNCREATE(CMyView)

// Attributes
public:
    CMyDoc *GetDocument(void);

// Operations
public: 
    virtual void OnInitialUpdate(void);  
    void BackUpClient(void);
    void AllocDC(CDC *&, CBitmap *&, CBitmap *&, int, int); 
    void FreeDC(CDC *, CBitmap *, CBitmap *);
    void SetNextPoint(void);
    void SetNextPos(void); 
    void SetNextFrame(void);
    void DrawSprite(void); 
    BOOL LeftMouseDown(void)
    {
        return LeftMouse;
    }
    BOOL RightMouseDown(void)
    {
        return RightMouse;
    }

// Implementation
public:
    virtual ~CMyView(void);
    virtual void OnDraw(CDC *pDC);  // overridden to draw this view
#ifdef _DEBUG
    virtual void AssertValid(void) const;
    virtual void Dump(CDumpContext &) const;
#endif

protected:

// Generated message map functions
protected:
    //{{AFX_MSG(CMyView)
        afx_msg void OnLButtonDown(UINT, CPoint);
        afx_msg void OnSize(UINT, int, int);
        afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnDestroy();
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    //}}AFX_MSG
        afx_msg LONG OnDrawSprite(UINT, LONG);
    DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in myview.cpp
inline CMyDoc *CMyView::GetDocument(void)
{ 
    return (CMyDoc *)m_pDocument; 
}
#endif

/////////////////////////////////////////////////////////////////////////////
