// MyView.cpp : implementation of the CMyView class
//

#include "Stdafx.h"

#include "CDib.h"

#include "My.h"

#include "MyDoc.h"
#include "MyView.h"

#include "MainFrm.h"         // for Timer Procs
#include "stdlib.h"          // for abs() function

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyView

IMPLEMENT_DYNCREATE(CMyView, CView)

BEGIN_MESSAGE_MAP(CMyView, CView)
    //{{AFX_MSG_MAP(CMyView)
        ON_WM_LBUTTONDOWN()
        ON_WM_SIZE()
        ON_WM_RBUTTONUP()
        ON_WM_RBUTTONDOWN()
        ON_WM_DESTROY()
        ON_WM_LBUTTONUP()
        ON_WM_TIMER()
    //}}AFX_MSG_MAP
        ON_MESSAGE(ID_DrawSprite, OnDrawSprite)
END_MESSAGE_MAP()
                                                          
////////////////////////////////////////////////////////////
// CMyView construction/destruction

CDib Image("IMAGE.DIB"),            // full image
     Mask("MASK.DIB"),              // short mask
     Pattern("Pattern.DIB");        // background
     
CRect NullFrame = CRect(0,0,0,0);     

void CMyView::AllocDC(CDC *&pDC, 
                      CBitmap *&pMap, CBitmap *&pOldMap, 
                      int Width, int Height)
{
    CClientDC cDC(this);
    pDC = new CDC;
    pDC->CreateCompatibleDC(&cDC);
    pMap = new CBitmap;                 
    pMap->CreateCompatibleBitmap(&cDC, Width, Height);
    pOldMap = pDC->SelectObject(pMap);
}                           

void CMyView::FreeDC(CDC *pDC, 
                     CBitmap *pMap, CBitmap *pOldMap)
{
    pDC->SelectObject(pOldMap);
    pMap->DeleteObject();            
    delete pMap;
    delete pDC; 
}    
        
CMyView::CMyView(void)
{
    // TODO: add construction code here
    
    Frame = NullFrame;
    FrameWidth  = Width  = Mask.DibWidth();
    FrameHeight = Height = Mask.DibHeight();                   
    Count  = Image.DibWidth() / Width;               
    Rad = Width / 2;
    Pos = 0;  
                                            
    LeftMouse = RightMouse = 
        ClientShown = UserReSize = Launched = FALSE;
    DoTurn = DoMove = FALSE;
}                              

void CMyView::OnInitialUpdate(void)
{                                                                 
    AllocDC(pBackDC, pBackMap, pOldBack, 
            ClientWidth, ClientHeight);
    AllocDC(pSaveDC, pSaveMap, pOldSave, 
            FrameWidth, FrameHeight);
    AllocDC(pWorkDC, pWorkMap, pOldWork, 
            FrameWidth, FrameHeight);
    
    CView::OnInitialUpdate();   // calls CView::OnUpdate with no hints
}

CMyView::~CMyView(void)
{    
    FreeDC(pWorkDC, pWorkMap, pOldWork);           
    FreeDC(pSaveDC, pSaveMap, pOldSave);           
    FreeDC(pBackDC, pBackMap, pOldBack);           
}

////////////////////////////////////////////////////////////
// CMyView sizing and drawing

void CMyView::OnSize(UINT nType, int cx, int cy)
{
    CView::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here

    L = Rad;
    T = Rad;
    R = (ClientWidth  = cx) - Rad;
    B = (ClientHeight = cy) - Rad;
    Center = CPoint(cx / 2, cy / 2);        
    if(ClientShown) {
        UserReSize = TRUE;
        Invalidate();  
    }    
}

void CMyView::BackUpClient(void)
{
        // copy Client to Back area                          
    CClientDC cDC(this);                    
    pBackDC->BitBlt(                    
                 0, 0,                       // dst (x,y)
                 ClientWidth, ClientHeight,  // dst
                 &cDC,                       // src
                 0, 0,                       // src (x,y)
                 SRCCOPY
             );                                                 
}

void CMyView::OnDraw(CDC *pDC)
{
    CMyDoc *pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here  

        // stretch Pattern to Client area
    int PatternWidth  = Pattern.DibWidth(),
        PatternHeight = Pattern.DibHeight();
  ::StretchDIBits(
       pDC->GetSafeHdc(),              // dst
       0, 0,                           // dst
       ClientWidth, ClientHeight,      // dst
       0, 0,                           // src
       PatternWidth, PatternHeight,    // src
       Pattern.DibBitsPtr(),           // src
       Pattern.DibInfoQuadPtr(),       // src
       DIB_RGB_COLORS,
       SRCCOPY
    );
    if(!ClientShown) {
        ClientShown = TRUE;
        BackUpClient();    
    }
    if(UserReSize) {
        UserReSize = FALSE;
        FreeDC(pBackDC, pBackMap, pOldBack);                        
        AllocDC(pBackDC, pBackMap, pOldBack, 
                ClientWidth, ClientHeight);
        BackUpClient();
    }
}

////////////////////////////////////////////////////////////
// CMyView diagnostics

#ifdef _DEBUG
void CMyView::AssertValid(void) const
{
    CView::AssertValid();
}

void CMyView::Dump(CDumpContext &dc) const
{
    CView::Dump(dc);
}

CMyDoc *CMyView::GetDocument(void) 
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMyDoc)));
    return (CMyDoc *)m_pDocument;
}
#endif //_DEBUG

////////////////////////////////////////////////////////////
// CMyView message handlers   

void CMyView::SetNextPoint(void)
{       
    int x = Current.x;
    if(dx > 0) 
        if(x + dx < R) 
            x += dx;
        else
            x = 2 * R - (x + dx), dx = -dx;
    else
        if(x + dx > L)
            x += dx;
        else
            x = 2 * L - (x + dx), dx = -dx;
    int y = Current.y;
    if(dy > 0) 
        if(y + dy < B) 
            y += dy;
        else
            y = 2 * B - (y + dy), dy = -dy;
    else
        if(y + dy > T)
            y += dy;
        else
            y = 2 * T - (y + dy), dy = -dy;
    Current = CPoint(x, y);            
}  

void CMyView::SetNextFrame(void)
{
    PrevFrame = Frame;
    SetNextPoint();
    Frame = CRect(
                Current.x - Rad, Current.y - Rad,
                Current.x + Rad, Current.y + Rad
            );
}          

void CMyView::DrawSprite(void)
{                                  
    SetNextFrame();

        // create cliping region RGN_DIFF(PrevFrame,Frame)
    CRgn Clip, FrameRgn, PrevFrameRgn;
    BOOL ResFrameRgn = FrameRgn.CreateRectRgnIndirect(&Frame);
    BOOL ResPrevFrameRgn = 
        PrevFrameRgn.CreateRectRgnIndirect(&PrevFrame);
    Clip.CreateRectRgn(0,0,0,0);       
    int ResCombineRgn = 
        Clip.CombineRgn(&PrevFrameRgn, &FrameRgn, RGN_DIFF);
    
        // set clipping region
    CClientDC cDC(this);                               
    int ResClipRgn = cDC.SelectClipRgn(&Clip);          
    CRect ClipBox;
    int ResClipBox = cDC.GetClipBox(&ClipBox);
    
        // clip-restore PrevFrame from Save area
    cDC.BitBlt(                    
        PrevFrame.left, PrevFrame.top,  // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        pSaveDC,                        // src
        0, 0,                           // src (x,y)
        SRCCOPY
    ); 
    
        // restore default clipping region
    int ResNullRgn = cDC.SelectClipRgn(NULL);
    CRect NullClipBox;         
    int ResNullClipBox = cDC.GetClipBox(&NullClipBox);
    
        // copy Frame from Back to Save area
    pSaveDC->BitBlt(                    
        0, 0,                           // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        pBackDC,                        // src
        Frame.left, Frame.top,          // src (x,y)
        SRCCOPY
    );    
        // copy Frame from Back to Work area
    pWorkDC->BitBlt(                    
        0, 0,                           // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        pBackDC,                        // src
        Frame.left, Frame.top,          // src (x,y)
        SRCCOPY
    );    
    
        // insert Mask to Work area
  ::StretchDIBits(
        pWorkDC->GetSafeHdc(),          // dst
        0, 0,                           // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        0, 0,                           // src (x,y)
        Width, Height,                  // src
        Mask.DibBitsPtr(),              // src
        Mask.DibInfoQuadPtr(),          // src
        DIB_RGB_COLORS,
        SRCAND                          // AND
    );     
    
        // insert Image to Work area
  ::StretchDIBits(
        pWorkDC->GetSafeHdc(),          // dst
        0, 0,                           // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        LeftPos, 0,                     // src (x,y)
        Width, Height,                  // src
        Image.DibBitsPtr(),             // src
        Image.DibInfoQuadPtr(),         // src
        DIB_RGB_COLORS,
        SRCINVERT                       // XOR
    );

        // copy Work area to Client area
    cDC.BitBlt(                    
        Frame.left, Frame.top,          // dst (x,y)
        FrameWidth, FrameHeight,        // dst
        pWorkDC,                        // src
        0, 0,                           // src (x,y)
        SRCCOPY
    );
}                        

LONG CMyView::OnDrawSprite(UINT, LONG)
{
    DrawSprite();
    return 0;
}    

void CALLBACK EXPORT 
MoveTimerProc(HWND, UINT, UINT, DWORD Time)      // Move
{   
    CMainFrame *pFrame = 
        (CMainFrame *)AfxGetApp()->m_pMainWnd;
    CMyView *pView = (CMyView *)pFrame->GetActiveView();
    
    if(pView->LeftMouseDown()) {
        pView->DoMove = TRUE;
        pView->PostMessage(WM_TIMER);
    }
}                                                   

void CMyView::SetNextPos(void)
{
    Pos = (Pos + 1) % Count;  
    LeftPos = Pos * Width;
}

void CALLBACK EXPORT 
TurnTimerProc(HWND, UINT, UINT, DWORD Time)      // Turn
{   
    CMainFrame *pFrame = 
        (CMainFrame *)AfxGetApp()->m_pMainWnd;
    CMyView *pView = (CMyView *)pFrame->GetActiveView();   
    
    pView->DoTurn = TRUE;
    pView->PostMessage(WM_TIMER);
}                                 

void CMyView::OnLButtonDown(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here
     
    LeftMouse = TRUE;
    CView::OnLButtonDown(nFlags, Point);
}   

void CMyView::OnRButtonDown(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here
    
    RightMouse = TRUE;
    
    CView::OnRButtonDown(nFlags, Point);
}

void CMyView::OnRButtonUp(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here
    
    RightMouse = FALSE;
    DrawSprite();
    
    CView::OnRButtonUp(nFlags, Point);
}

void CMyView::OnDestroy(void)                                                  
{
    CView::OnDestroy();
    
    // TODO: Add your message handler code here 
}

void CMyView::OnTimer(UINT nIDEvent)
{
    // TODO: Add your message handler code here
    
    if(TRUE || DoTurn) {
        DoTurn = FALSE;
        SetNextPos();    
    }
    if(TRUE || DoMove) {
        DoMove = FALSE;
        DrawSprite();
    }        
    
    CView::OnTimer(nIDEvent);
}

void CMyView::OnLButtonUp(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here
     
    LeftMouse = FALSE;    
    if(!Launched) {     
        extern int Move, Turn, xDelta, yDelta; 
        Current = Center;  
        dx = xDelta, dy = -yDelta;
        LeftPos = 0;                  
        int TimerId = SetTimer(5, Move, NULL );  
        CMainFrame *pFrame = 
            (CMainFrame *)AfxGetApp()->m_pMainWnd;       
        Launched = TRUE; 
        DrawSprite();

    }
    
    CView::OnLButtonUp(nFlags, point);
}

