// MyView.cpp : implementation of the CMyView class
//

#include "stdafx.h"
#include "My.h"

#include "MyDoc.h"
#include "MyView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyView

int CMyView::w,
    CMyView::h;

CDC CMyView::mDC, *CMyView::pDC;

CObArray CMyView::dataBase;

int CMyView::drawCode(void *pArg)
{
    CSection &drawLock = *(CSection *)pArg;
    while(true) {
            // wykrelenie k
        mDC.Rectangle(-1, -1, w+1, h+1);
        drawLock.enterSection();
            drawAll(&mDC);
        drawLock.leaveSection();

            // skopiowanie bufora na ekran
        pDC->BitBlt(
            0, 0,    // dst
            w, h,    // dst
            &mDC,    // src
            0, 0,    // src
            SRCCOPY
        );        
        sleep(10);
    }
}

IMPLEMENT_DYNCREATE(CMyView, CView)

BEGIN_MESSAGE_MAP(CMyView, CView)
	//{{AFX_MSG_MAP(CMyView)
	ON_WM_LBUTTONUP()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyView construction/destruction

CMyView::CMyView()
{
	// TODO: add construction code here

    afterOnDraw = false;
}

CMyView::~CMyView()
{
}

BOOL CMyView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMyView drawing

void CMyView::OnDraw(CDC* pDC)
{
	CMyDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

    afterOnDraw = true;

    drawAll(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CMyView printing

BOOL CMyView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMyView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMyView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMyView diagnostics

#ifdef _DEBUG
void CMyView::AssertValid() const
{
	CView::AssertValid();
}

void CMyView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMyDoc* CMyView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMyDoc)));
	return (CMyDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyView message handlers

void CMyView::drawAll(CDC *pDC)
{
    for(int i = 0; i < dataBase.GetSize() ; i++) {
        Circle *pCircle = (Circle *)dataBase.GetAt(i);
        pCircle->draw(pDC);
    }
}

void CMyView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

        // przygotowanie wykrelaczy
    pDC = new CClientDC(this);
    mDC.CreateCompatibleDC(pDC);    

        // przygotowanie bitmapy
    pMap = new CBitmap;
    pMap->CreateCompatibleBitmap(pDC, w, h);

        // wstawienie bitmapy do wykrelacza
    pOldMap = mDC.SelectObject(pMap);	

        // utworzenie wtku wykrelajcego
    pDrawThread = new CWorkerThread(drawCode, &drawLock);
}

BOOL CMyView::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class

        // pozbycie sie wykrelacza
    delete pDC;

        // pozbycie si bitmapy
    mDC.SelectObject(pOldMap); 
    delete pMap;
    
	return CView::DestroyWindow();
}

void CMyView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

    int x = point.x,
        y = point.y,
        r = Circle::r;
    if(x > r && y > r && x < w-r && y < h-r) {
        drawLock.enterSection();
            Circle *pCircle = new Circle(point);
            dataBase.Add(pCircle);
        drawLock.leaveSection();
    } else
        MessageBeep(0);
	
	CView::OnLButtonUp(nFlags, point);
}

void CMyView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here

    if(afterOnDraw)
            // zabroniono zmiany rozmiarw
        exit(0);
    else {
        w = cx;
        h = cy;
    }
}
