// MyLine.cpp : implementation file
//

#include "stdafx.h"
#include "Lines.h"
#include "MyLine.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyLine

IMPLEMENT_SERIAL(CMyLine, CDocument, 1)

CMyLine::CMyLine()
{
}

BOOL CMyLine::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CMyLine::~CMyLine()
{
}


BEGIN_MESSAGE_MAP(CMyLine, CDocument)
	//{{AFX_MSG_MAP(CMyLine)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyLine diagnostics

#ifdef _DEBUG
void CMyLine::AssertValid() const
{
	CDocument::AssertValid();
}

void CMyLine::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyLine serialization

void CMyLine::Serialize(CArchive &ar)
{
	CDocument::Serialize(ar);
	if(ar.IsStoring()) {
		ar << aPoint << zPoint << Color;
	} else {
		ar >> aPoint >> zPoint >> Color;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMyLine commands


CMyLine::CMyLine(CPoint aPoint, CPoint zPoint,
                 COLORREF Color) :
	aPoint(aPoint), 
	zPoint(zPoint), 
	Color(Color)
{
}                    

void CMyLine::SetTail(CPoint Point)
{
	zPoint = Point;
}                                   

void CMyLine::SetColor(COLORREF Color)
{
	CMyLine::Color = Color;
}

void CMyLine::DrawLine(CDC &cDC, int Mode)
{       
	CPen Pen(PS_SOLID, 1, Color), *pPen;
	pPen = cDC.SelectObject(&Pen);
	Mode = cDC.SetROP2(Mode);
	cDC.MoveTo(aPoint);
	cDC.LineTo(zPoint);
	cDC.SelectObject(pPen);            // restore pen
	cDC.SetROP2(Mode);                 // restore mode
}

CPoint CMyLine::GetHead(void)
{
	return aPoint;
}

CPoint CMyLine::GetTail(void)
{
	return zPoint;
}

void CMyLine::GetLine(CPoint &aPoint, CPoint &zPoint)
{
    aPoint = this->aPoint;
	zPoint = this->zPoint;
}


#if 0 // OLD

#include "stdafx.h"

#include "MyLine.h"

IMPLEMENT_SERIAL(CMyLine, CObject, 1)

void CMyLine::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);
	if(ar.IsStoring()) {
		ar << aPoint << zPoint << Color;
	} else {
		ar >> aPoint >> zPoint >> Color;
	}
}

CMyLine::CMyLine(void) // for Serialize
{
}

CMyLine::CMyLine(CPoint aPoint, CPoint zPoint,
                 COLORREF Color) :
	aPoint(aPoint), 
	zPoint(zPoint), 
	Color(Color)
{
}                    

void CMyLine::SetTail(CPoint Point)
{
	zPoint = Point;
}                                   

void CMyLine::SetColor(COLORREF Color)
{
	CMyLine::Color = Color;
}

void CMyLine::DrawLine(CDC &cDC, int Mode)
{       
	CPen Pen(PS_SOLID, 1, Color), *pPen;
	pPen = cDC.SelectObject(&Pen);
	Mode = cDC.SetROP2(Mode);
	cDC.MoveTo(aPoint);
	cDC.LineTo(zPoint);
	cDC.SelectObject(pPen);            // restore pen
	cDC.SetROP2(Mode);                 // restore mode
}

CPoint CMyLine::GetHead(void)
{
	return aPoint;
}

CPoint CMyLine::GetTail(void)
{
	return zPoint;
}

void CMyLine::GetLine(CPoint &aPoint, CPoint &zPoint)
{
    aPoint = this->aPoint;
	zPoint = this->zPoint;
}

#endif
