// LinesView.h : interface of the CLinesView class
//
/////////////////////////////////////////////////////////////////////////////

class CMyLine;
class CLinesDoc;
class CMyList;
class CLinesFrm;

class CLinesView : public CView {
protected: // create from serialization only
	CLinesView();

	DECLARE_DYNCREATE(CLinesView)

// Attributes
public:
	CLinesDoc *GetDocument();
private:
    CButton *pQuit;
    CStatic *pPress;
    CFont *pFont;
    BOOL DownFlag;
    CMyLine *pLine;   // wymaga class CMyLine;
    CPoint Center,    // rodek widoku
           Point;    // punkt zaczepienia
    COLORREF LineColor;

    CMyList *pListDialog;

// Operations
public:
    void DrawRect(CDC *);
    CLinesFrm *GetFrame(void);
    CPoint GetCenter(void);
    void SetModifiedFlag(void);
    void MoveWindow(CMyList *);
    CMyList *GetListDialogPtr();

#if defined(Multi)
    COLORREF GetColor()
    {
        return LineColor;
    }
#endif

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CLinesView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CLinesView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CLinesView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRed();
	afx_msg void OnGreen();
	afx_msg void OnBlue();
	afx_msg void OnCustom();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnViewList();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnUpdateViewList(CCmdUI* pCmdUI);
	//}}AFX_MSG

    // jb man. add
    afx_msg void OnQuit();  
    afx_msg LONG OnListClosed(UINT, LONG);

	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in LinesView.cpp
inline CLinesDoc* CLinesView::GetDocument()
   { return (CLinesDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
