#include "stdafx.h"
#include "mystring.h"

#include "myview.h"

IMPLEMENT_SERIAL(CMyString, CObject, 1)

CMyString::CMyString(void)               // for Serialize
{
}

CMyString::CMyString(CMyView *pMyView, 
					 CPoint Pt, CString Str) :
	Pt(Pt), Str(Str)
{                      
	CClientDC cDC(pMyView);
	Ext = cDC.GetTextExtent(Str, Str.GetLength()); 	
}

CMyString::CMyString(const CMyString &Str) :      // no default!
	Pt(Str.Pt), Ext(Str.Ext), Str(Str.Str)
{                                     
}
	
CMyString *CMyString::Draw(CDC &cDC, BOOL Red)
{       
    if(Red)
    	cDC.SetTextColor(RGB(255,0,0));
    cDC.SetBkMode(TRANSPARENT);
	cDC.DrawText(Str, Str.GetLength(),
				 &GetRect(),
				 DT_LEFT);
	if(Red)
		cDC.SetTextColor(RGB(0,0,0));

	return this;
}

CString CMyString::GetStr(void)
{
	return Str;
}

CRect &CMyString::GetRect(void)
{
	static CRect Rect;
	Rect = CRect(Pt.x, Pt.y, 
				(Pt + Ext).x, (Pt + Ext).y);
	return Rect;			
}

void CMyString::Serialize(CArchive &Ar)
{
	if(Ar.IsStoring()){
		Ar << (WORD)Pt.x  << (WORD)Pt.y  <<
			  (WORD)Ext.cx << (WORD)Ext.cy << Str;	
	} else {
		WORD x, y;
		Ar >> x >> y, Pt.x  = x, Pt.y  = y;
		Ar >> x >> y, Ext.cx = x, Ext.cy = y;
		Ar >> Str;	
	}
}	

BOOL CMyString::PointInRect(CPoint Point)
{              
	return GetRect().PtInRect(Point);
}
                
void CMyString::DrawDottedRect(CDC &cDC)
{
	CPen Pen(PS_DOT, 1, RGB(0,0,0)), *pOldPen;
	pOldPen = cDC.SelectObject(&Pen);      
	CBrush *pOldBrush =
		(CBrush *)cDC.SelectStockObject(NULL_BRUSH); 
	cDC.SetBkMode(TRANSPARENT);
	int Mode = cDC.SetROP2(R2_NOT);
	cDC.Rectangle(&GetRect());	
	cDC.SetROP2(Mode);
	cDC.SelectObject(pOldBrush);
	cDC.SelectObject(pOldPen);
}

CPoint HotSpot;             

void CMyString::SetHotSpot(CPoint Point)
{
	HotSpot = Point;
}

void CMyString::Draw(CDC &cDC, CPoint Point)
{
	DrawDottedRect(cDC);
	Pt += Point - HotSpot;
	DrawDottedRect(cDC);
	HotSpot = Point;
}