// MyView.cpp : implementation of the CMyView class
//

#include "stdafx.h"
#include "My.h"

#include "MyDoc.h"
#include "MyView.h"

#include "MainFrm.h"      // jb added

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyView

const int width  = 500,
          height = 500;

IMPLEMENT_DYNCREATE(CMyView, CView)

BEGIN_MESSAGE_MAP(CMyView, CView)
	//{{AFX_MSG_MAP(CMyView)
	ON_WM_TIMER()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_LBUTTONUP()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyView construction/destruction

CMyView::CMyView()
{
TRACE("CMyView\n");
	// TODO: add construction code here
    ww = 300;
    hh = 300;
}

CMyView::~CMyView()
{
}

BOOL CMyView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

    static CBitmap bitmap_8x8;
    bitmap_8x8.LoadBitmap(IDB_MyBitmap);
    static CBrush brush;
    brush.CreatePatternBrush(&bitmap_8x8);

    CWinApp *pApp = AfxGetApp();

        // zarejestowanie "klasy" okna widoku
    static CString myWndClass =
        AfxRegisterWndClass(
            CS_DBLCLKS,                      // styl
            pApp->LoadCursor(IDC_MyCursor),  // kursor
            brush,                           // pdzel
            pApp->LoadIcon(IDI_MyViewIcon)   // ikona
        );        
    cs.lpszClass = myWndClass;


	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMyView drawing

void CMyView::OnDraw(CDC *pDC)
{
	CMyDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here

#if 0
    static bool wasHere = false;
    if(!wasHere) {
        wasHere = true;
        CRect fRect;
        extern CMainFrame *pFrame;
        pFrame->GetWindowRect(&fRect);
        static int fw = (fRect.right  - fRect.left),
                   fh = (fRect.bottom - fRect.top);
        CRect client;
        GetClientRect(&client);
        int cw = client.right,
            ch = client.bottom;
        pFrame->MoveWindow(0, 0, fw += ww-cw, fh += hh-ch);
        pFrame->RecalcLayout();
#else 
    static bool workDone = false;
    if(!workDone) {
        workDone = true;
        CRect fRect;
        CMainFrame *pFrame = (CMainFrame *)AfxGetMainWnd();
        pFrame->GetWindowRect(&fRect);
        static int fw = (fRect.right  - fRect.left),
                   fh = (fRect.bottom - fRect.top);
        CRect client;
        GetClientRect(&client);
        int cw = client.right,
            ch = client.bottom;
        pFrame->MoveWindow(0, 0, fw += width-cw, fh += height-ch);
        pFrame->RecalcLayout();
#endif
            // seems unnecessary
//        Invalidate();
//        return;
    }

    CRect client;
    GetClientRect(&client);
    int w = client.right,
        h = client.bottom;

    CDC mDC;
    mDC.CreateCompatibleDC(pDC);    

// === Bitmap prolog
    CBitmap *pMap = new CBitmap, *pOldMap;
    pMap->CreateCompatibleBitmap(pDC, w, h);
    pOldMap = mDC.SelectObject(pMap);
// ===

#if 1
// === show Background
    CDC mDC2;
    mDC2.CreateCompatibleDC(pDC);
    static CBitmap backMap2, *pOldMap2;
    static bool loaded = false;
    if(!loaded) {
        loaded = true;
	    backMap2.LoadBitmap(MyBack);
    }
    pOldMap2 = mDC2.SelectObject(&backMap2);
    mDC.StretchBlt(
        0,        // x dst
        0,        // y dst
        w,        // w dst
        h,        // h dst
        &mDC2,    // src DC
        0,        // x src
        0,        // y src
        50,       // w src
        50,       // h src
        SRCCOPY   // mode
    );
    mDC2.SelectObject(pOldMap2);
// ===
#else
    mDC.SelectStockObject(WHITE_PEN);
    mDC.Rectangle(0, 0, w, h);
#endif

// === Pen prolog
    CPen redPen(PS_SOLID, 1, RGB(255,0,0)),
         *pOldPen;
    pOldPen = mDC.SelectObject(&redPen);
// ===

    mDC.SelectStockObject(BLACK_PEN);
    mDC.MoveTo(0, 0);
    mDC.LineTo(w, h);

// === Brush prolog
	CBitmap *pBitmap;
	CBrush *pOldBrush;
	pBitmap = new CBitmap; 
	pBitmap->LoadBitmap(MyBitmap);
	CBrush MyBrush(pBitmap);
	pOldBrush = mDC.SelectObject(&MyBrush);
// ===

    mDC.Ellipse(x-rad, y-rad, x+rad+1, y+rad+1);

    pDC->BitBlt(
        0, 0,    // dst
        w, h,    // dst
        &mDC,    // src
        0, 0,    // src
        SRCCOPY
    );        

// === Brush epilog
	mDC.SelectObject(pOldBrush);
	pBitmap->DeleteObject();
	delete pBitmap;
// ===

// === Pen epilog
    mDC.SelectObject(pOldPen);
// ===

// === Bitmap epilog
    mDC.SelectObject(pOldMap);
    delete pMap;
// ===
}

/////////////////////////////////////////////////////////////////////////////
// CMyView printing

BOOL CMyView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMyView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMyView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMyView diagnostics

#ifdef _DEBUG
void CMyView::AssertValid() const
{
	CView::AssertValid();
}

void CMyView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMyDoc* CMyView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMyDoc)));
	return (CMyDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyView message handlers

void CMyView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
    CRect client;
    GetClientRect(&client);
    int w = client.right,
        h = client.bottom;

    int r4 = rad>>3;
    if(w == h) {
        x = n * r4;
        y = n * r4;
    }
    else if(w > h) {
        x = n * w/h * r4;
        y = n * r4;
    }
    else if(h > w) {
        y = n * h/w * r4;
        x = n * r4;
    }
    n++;
    if(x > w || y > h) {
        KillTimer(1);
        x = y = -rad;
    }
//    Invalidate();    // blinks
    CClientDC cDC(this);
    OnDraw(&cDC);

	CView::OnTimer(nIDEvent);
}

int CMyView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
TRACE("OnCreate: View\n");
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	return 0;
}

void CMyView::OnDestroy() 
{
TRACE("OnDestroy: View\n");
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	KillTimer(1);
}

void CMyView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
}

void CMyView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    KillTimer(1);
    rad = 20;
    n = 0;
    x = y = 0;
	SetTimer(1, 100, 0);

	CView::OnLButtonUp(nFlags, point);
}

void CMyView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
}
