// mydoc.cpp : implementation of the CMyDoc class
//

#include "Stdafx.h"
#include "My.h"

#include "MyDoc.h"

#include "MyString.h"
#include "MyView.h"
#include "MyEdit.h"
#include "MainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyDoc

IMPLEMENT_DYNCREATE(CMyDoc, CDocument)

BEGIN_MESSAGE_MAP(CMyDoc, CDocument)
	//{{AFX_MSG_MAP(CMyDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyDoc construction/destruction

CMyDoc::CMyDoc()
{
	// TODO: add one-time construction code here
	DocSizeSet = FALSE;
}

CMyDoc::~CMyDoc()
{
}

BOOL CMyDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
                                       
	POSITION Pos;                             
	Pos = GetFirstViewPosition();          
	pMyView = (CMyView *)GetNextView(Pos);
	if(!pMyView->pEditDlg)
    	(pMyView->pEditDlg = 
    		new CMyEdit(pMyView, "Hello"))->Create();
	SetModifiedFlag(FALSE);    		
	DocSizeSet = FALSE;
	UpdateAllViews(NULL);    
	return TRUE;
}                

BOOL CMyDoc::OnOpenDocument(const char *Name)
{       
	BOOL Flag;		                       
#if 1	
	Flag = CDocument::OnOpenDocument(Name);  // DeleteContents, Serialize		                     
#else
	// My customized Open
	DeleteContents();
	// Flag = ...
#endif	
	if(Flag){                                             
		SetModifiedFlag(FALSE);
		DocSizeSet = TRUE;
		UpdateAllViews(NULL);                             
	}
	return Flag;
}		

BOOL CMyDoc::OnSaveDocument(const char *Name)
{   
	BOOL Flag;                                
#if 1
	Flag = CDocument::OnSaveDocument(Name);       // Serialize
#else
	// My customized Save
	// Flag = ...	
#endif	                       
	if(Flag)
		SetModifiedFlag(FALSE);
	return Flag; 
}	

/////////////////////////////////////////////////////////////////////////////
// CMyDoc serialization

void CMyDoc::Serialize(CArchive& Ar)
{
	if (Ar.IsStoring())
	{
		// TODO: add storing code here
		Ar << MyDocW << MyDocH;
	}
	else
	{
		// TODO: add loading code here     
		Ar >> MyDocW >> MyDocH;
	}           
	MyList.Serialize(Ar);
}

/////////////////////////////////////////////////////////////////////////////
// CMyDoc commands
                             
void CMyDoc::InsertAtTail(CMyString *pStrObj)
{   
	MyList.AddTail(pStrObj);
	SetModifiedFlag(TRUE);
}

void CMyDoc::DeleteContents(void)            // called at exit too
{                                                     
	if(!MyList.IsEmpty()){
		POSITION Pos = MyList.GetHeadPosition();
		while(Pos)
			delete (CMyString *)MyList.GetNext(Pos); 
		MyList.RemoveAll();
	}
	SetModifiedFlag(FALSE);
}  

BOOL CMyDoc::InsideDoc(CMyString *pStr)
{
	CRect DocRect(0, 0, MyDocW - 1, MyDocH - 1),
		  StrRect = pStr->GetRect(); 
	return (DocRect & StrRect) == StrRect;     // jb ?? why (...)
}

void CMyDoc::UpdateDocSize(int w, int h)
{
	if(!DocSizeSet)
		MyDocW = w, MyDocH = h;
}		

POSITION Pos;

CMyString *CMyDoc::SelectTheStr(CPoint Point)
{       
	CMyString *pStr;
	if(!MyList.IsEmpty()){
		POSITION Pos = MyList.GetTailPosition();
		while(Pos){
			pStr = (CMyString *)MyList.GetAt(Pos);
			if(pStr->PointInRect(Point)){
				::Pos = Pos;
				return pStr;
			}
			MyList.GetPrev(Pos);
		}                       
	}
	return NULL;
}   

void CMyDoc::DeleteTheStr(void)
{
	if(!MyList.IsEmpty()){
		MyList.RemoveAt(Pos);                     // remove pointer
		delete (CMyString *)MyList.GetAt(Pos);    // to avoid leaks!
	}
	pMyView->pTheStr = NULL;
	SetModifiedFlag(TRUE);
}	
