#include <AfxWin.h>
#include "resource.h"                  // for ID_EXIT


// ======================================= CMyApp

class CMyApp : public CWinApp {
public:
	virtual BOOL InitInstance(void);
protected:
	afx_msg void onExit(void);

	DECLARE_MESSAGE_MAP()
};                                    

CMyApp MyApp;                          // application object

BEGIN_MESSAGE_MAP(CMyApp, CWinApp)     

	ON_COMMAND(ID_EXIT, onExit)        // File/Exit command
	
END_MESSAGE_MAP()


// ======================================= CMainFrame

class CMainFrame : public CFrameWnd {         
private:
	CPoint center;
public: 
	BOOL Create(CString, CString);     // create frame
	virtual void PostNcDestroy(void);  // destroy frame object
protected:	
    //{{AFX_MSG(CMainFrame)
    afx_msg void OnSize(UINT, int, int);
	afx_msg void OnPaint(void);
	afx_msg void OnClose(void);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

BOOL CMainFrame::Create(CString caption, CString menuName)
{  
	static CString wndClass =               // beware of auto!
		AfxRegisterWndClass(
			CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
            AfxGetApp()->LoadStandardCursor(IDC_ARROW),
			(HBRUSH)::GetStockObject(WHITE_BRUSH),
			AfxGetApp()->LoadStandardIcon(IDI_APPLICATION)
		);	        
 
	BOOL result = 
		CFrameWnd::Create(
            wndClass,             // window class
	        caption,              // frame caption
	        WS_OVERLAPPEDWINDOW,  // window style
	        rectDefault,          // default size
	        0,                    // no parent
	        menuName                  // menu name
	   );  
	return result;
}         

void CMainFrame::OnClose(void)    // close box
{
	DestroyWindow();	          // frame object still exists
}	                        

void CMainFrame::PostNcDestroy(void)      
{
	delete this;                  // destroy frame object
}

CMainFrame *pFrame;

BOOL CMyApp::InitInstance(void)            // called from WinMain
{                   
                             // Frame object creation 
	m_pMainWnd = pFrame = new CMainFrame;
							 // Frame window creation
	BOOL result = 
		pFrame->Create(
	                "Ellipse",       // frame caption
		            "MyMenu"         // frame menu name
                );
	pFrame->ShowWindow(m_nCmdShow);                      
	
	return result;                     // TRUE for success
}

void CMyApp::onExit(void)
{   
	pFrame->SendMessage(WM_CLOSE);
}                  

// ======================================= messages

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
    //{{AFX_MSG_MAP(CMainFrame)
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CMainFrame::OnSize(UINT, int cx, int cy)
{   
	center = CPoint(cx/2, cy/2);
}

void CMainFrame::OnPaint(void)
{                 
	PAINTSTRUCT paint;                                    
	CDC *pDC = BeginPaint(&paint);            // validates client
	CRect rect;
	GetClientRect(rect);
	CBrush redBrush(RGB(255,0,0)), *pOldBrush;
	pOldBrush = pDC->SelectObject(&redBrush);
	pDC->Ellipse(rect);      
	pDC->SetPixel(center, RGB(0,0,0));        // black pixel
	pDC->SelectObject(pOldBrush);
	EndPaint(&paint);
}

void CMainFrame::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
TRACE("L-up\n");
	
	CFrameWnd::OnLButtonUp(nFlags, point);
}

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
TRACE("L-dn\n");
	
	CFrameWnd::OnLButtonDown(nFlags, point);
}

void CMainFrame::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
TRACE("L-dbl\n");
	
	CFrameWnd::OnLButtonDblClk(nFlags, point);
}
