// MyView.cpp : implementation of the CMyView class
//

#include "Stdafx.h"
#include "My.h"
#include "Mydoc.h"
#include "MyView.h"
#include "MyNum.h"
#include "MyRng.h"

/////////////////////////////////////////////////////////////////////////////
// CMyView

IMPLEMENT_DYNCREATE(CMyView, CView)

BEGIN_MESSAGE_MAP(CMyView, CView) 

    //{{AFX_MSG_MAP(CMyView)
        ON_WM_LBUTTONUP()
        ON_WM_RBUTTONUP()
    //}}AFX_MSG_MAP
                           // required signature
                           // LONG Name(UINT, LONG)
    ON_MESSAGE(CloseRange, OnRngClose) 
    
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyView construction/destruction

CMyView::CMyView(void)
{
    // TODO: add construction code here 
    
    pMyRng = 0;
    Min = 0;
    Max = 255;
}

CMyView::~CMyView(void)
{             
    delete pMyRng;          // DestroyWindow, delete object
}

UINT CMyView::GetMin(void)
{
    return Min;
}

UINT CMyView::GetMax(void)
{
    return Max;
}

void CMyView::SetMinMax(UINT Min, UINT Max)
{
    CMyView::Min = Min;
    CMyView::Max = Max;
}

UINT CMyView::GetEditVal(void)
{    
    CMyDoc *pMyDoc = GetDocument();
    UINT Val = pMyDoc->GetVal();
    if( Val >= Min & Val <= Max)
        return Val;
    else
        return (Min + Max) / 2;
}

/////////////////////////////////////////////////////////////////////////////
// CMyView drawing

void CMyView::OnDraw(CDC *pDC)
{
    CMyDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
    
    char Num[6];
    wsprintf(Num, "%d", pDoc->GetVal());
    CRect Client;
    GetClientRect(Client);
    pDC->DrawText(Num, strlen(Num), Client, 
                  DT_SINGLELINE | DT_CENTER | DT_VCENTER);
}

CMyDoc *CMyView::GetDocument(void)
{
    return (CMyDoc *)m_pDocument;
}

void CMyView::OnLButtonUp(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here and/or call default  
                                    
    CMyDoc *pDoc = GetDocument();                                    
    CMyNum *pMyNum = new CMyNum(this, pDoc->GetVal());
    if(pMyNum->DoModal() != IDOK)
        ::MessageBeep(0);
    else {
        pDoc->SetVal(pMyNum->GetVal());
        Invalidate();
    }                 
    delete pMyNum;
    
    CView::OnLButtonUp(nFlags, Point);
}

void CMyView::OnRButtonUp(UINT nFlags, CPoint Point)
{
    // TODO: Add your message handler code here and/or call default 
    
    if(!pMyRng){
        pMyRng = new CMyRng(this, Min, Max);
        pMyRng->Create();            // create dialog window
    } else 
        OnRngClose();                // below

    CView::OnRButtonUp(nFlags, Point);
}   

LONG CMyView::OnRngClose(UINT, LONG)
{   
    pMyRng->DestroyWindow();
    delete pMyRng;
    pMyRng = 0; 
    return 0;
}
