// WstegaCtl.cpp : Implementation of the CWstegaCtrl ActiveX Control class.

#include "stdafx.h"
#include "Wstega.h"
#include "WstegaCtl.h"
#include "WstegaPpg.h"
#include "ModArt.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CWstegaCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CWstegaCtrl, COleControl)
	//{{AFX_MSG_MAP(CWstegaCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CWstegaCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CWstegaCtrl)
	DISP_PROPERTY_NOTIFY(CWstegaCtrl, "UtrzymajBRysunek", m_UtrzymajBRysunek, OnUtrzymajBRysunekChanged, VT_BOOL)
	DISP_PROPERTY_EX(CWstegaCtrl, "DlugoscWstegi", PobierzDlugoscWstegi, UstawDlugoscWstegi, VT_I2)
	DISP_PROPERTY_EX(CWstegaCtrl, "LiczbaWsteg", PobierzLiczbaWsteg, UstawLiczbaWsteg, VT_I2)
	DISP_STOCKFUNC_DOCLICK()
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CWstegaCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CWstegaCtrl, COleControl)
	//{{AFX_EVENT_MAP(CWstegaCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CWstegaCtrl, 1)
	PROPPAGEID(CWstegaPropPage::guid)
END_PROPPAGEIDS(CWstegaCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CWstegaCtrl, "WSTEGA.WstegaCtrl.1",
	0xeec5925, 0xa305, 0x11d2, 0xb3, 0xeb, 0x8d, 0xd4, 0x9a, 0x27, 0xed, 0x59)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CWstegaCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DWstega =
		{ 0xeec5923, 0xa305, 0x11d2, { 0xb3, 0xeb, 0x8d, 0xd4, 0x9a, 0x27, 0xed, 0x59 } };
const IID BASED_CODE IID_DWstegaEvents =
		{ 0xeec5924, 0xa305, 0x11d2, { 0xb3, 0xeb, 0x8d, 0xd4, 0x9a, 0x27, 0xed, 0x59 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwWstegaOleMisc =
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CWstegaCtrl, IDS_WSTEGA, _dwWstegaOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::CWstegaCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CWstegaCtrl

BOOL CWstegaCtrl::CWstegaCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_WSTEGA,
			IDB_WSTEGA,
			afxRegApartmentThreading,
			_dwWstegaOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::CWstegaCtrl - Constructor

CWstegaCtrl::CWstegaCtrl()
{
	InitializeIIDs(&IID_DWstega, &IID_DWstegaEvents);

	// TODO: Initialize your control's instance data here.
	// Inicjalizacja zmiennych
	m_bGenNowyRys = TRUE;
	m_UtrzymajBRysunek = FALSE;

}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::~CWstegaCtrl - Destructor

CWstegaCtrl::~CWstegaCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::OnDraw - Drawing function

void CWstegaCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	//pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	//pdc->Ellipse(rcBounds);
		// Czy naley utworzy nowy rysunek?
			if (m_bGenNowyRys)
			{
			// Ustawienie obszaru rysowania dla nowego rysunku
			m_maRysunek.UstawObszar(rcBounds);
			// Wyczyszenied starego rysunku
			m_maRysunek.CzyscRysunek();
			// Wygenerowanie nowego rysunku
			m_maRysunek.NowyRysunek();
			// Wyzerowanie znacznika nowego rysunku
			m_bGenNowyRys = FALSE;
		}
		// Wypenienie ta
		pdc->FillRect(rcBounds, 
		 CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
		// Tworzenie rysunku wstg
		m_maRysunek.Rysuj(pdc);

}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::DoPropExchange - Persistence support

void CWstegaCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::OnResetState - Reset control to default state

void CWstegaCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl::AboutBox - Display an "About" box to the user

void CWstegaCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_WSTEGA);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CWstegaCtrl message handlers

short CWstegaCtrl::PobierzDlugoscWstegi() 
{
	// TODO: Add your property handler here
	// Zwrcenie rezultatu dziaania funkcji PobierzDlugosc
	return m_maRysunek.PobierzDlugosc();

}

void CWstegaCtrl::UstawDlugoscWstegi(short nNewValue) 
{
	// TODO: Add your property handler here
	// Ustawienie nowej wartoci dugoci wstgi
	m_maRysunek.UstawDlugosc(nNewValue);

	SetModifiedFlag();
}

short CWstegaCtrl::PobierzLiczbaWsteg() 
{
	// TODO: Add your property handler here
	// Zwrcenie rezultatu dziaania funkcji PobierzSegmenty
	return m_maRysunek.PobierzSegmenty();

}

void CWstegaCtrl::UstawLiczbaWsteg(short nNewValue) 
{
	// TODO: Add your property handler here
	// Ustawienie nowej wartoci liczby wstg
	m_maRysunek.UstawSegmenty(nNewValue);

	SetModifiedFlag();
}

void CWstegaCtrl::OnUtrzymajBRysunekChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CWstegaCtrl::OnClick(USHORT iButton) 
{
	// TODO: Add your specialized code here and/or call the base class
	// Czy moliwe jest wygenerowanie nowego rysunku?
	if (!m_UtrzymajBRysunek)
	{
		// Ustawienie znacznika - wymuszenie nowego rysunku
		m_bGenNowyRys = TRUE;
		// Dezaktualizacja kontrolki, aby wywoana zostaa funkcja OnDraw
		 Invalidate();
		}
	
	COleControl::OnClick(iButton);
}
