// MdiDoc.cpp : implementation of the CMdiDoc class
//

#include "stdafx.h"
#include "Mdi.h"
#include "Linia.h"
#include "MdiDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMdiDoc

IMPLEMENT_DYNCREATE(CMdiDoc, CDocument)

BEGIN_MESSAGE_MAP(CMdiDoc, CDocument)
	ON_COMMAND_RANGE(ID_COLOR_BLACK, ID_COLOR_WHITE, OnKolorCommand)
	ON_UPDATE_COMMAND_UI_RANGE(ID_COLOR_BLACK, ID_COLOR_WHITE, OnUpdateColorUI)
	//{{AFX_MSG_MAP(CMdiDoc)
	ON_COMMAND(ID_COLOR_BLACK, OnColorBlack)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLACK, OnUpdateColorBlack)
	ON_COMMAND(ID_COLOR_BLUE, OnColorBlue)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLUE, OnUpdateColorBlue)
	ON_COMMAND(ID_COLOR_CYAN, OnColorCyan)
	ON_UPDATE_COMMAND_UI(ID_COLOR_CYAN, OnUpdateColorCyan)
	ON_COMMAND(ID_COLOR_GREEN, OnColorGreen)
	ON_UPDATE_COMMAND_UI(ID_COLOR_GREEN, OnUpdateColorGreen)
	ON_COMMAND(ID_COLOR_MAGENTA, OnColorMagenta)
	ON_UPDATE_COMMAND_UI(ID_COLOR_MAGENTA, OnUpdateColorMagenta)
	ON_COMMAND(ID_COLOR_RED, OnColorRed)
	ON_UPDATE_COMMAND_UI(ID_COLOR_RED, OnUpdateColorRed)
	ON_COMMAND(ID_COLOR_WHITE, OnColorWhite)
	ON_UPDATE_COMMAND_UI(ID_COLOR_WHITE, OnUpdateColorWhite)
	ON_COMMAND(ID_COLOR_YELLOW, OnColorYellow)
	ON_UPDATE_COMMAND_UI(ID_COLOR_YELLOW, OnUpdateColorYellow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

	const COLORREF CMdiDoc::m_crKolory[8] = {
		RGB(		0,	0,	0),		// Czarny
		RGB(		0,	0,	255),	// Niebieski
 		RGB(		0,	255,	0),		// Zielony
 		RGB(		0,	255,	255),	// Bkitny
 		RGB(		255,	0,	0),		// Czerwony
 		RGB(		255,	0,	255),	// Fioletowy
 		RGB(		255,	255,	0),		// ty
 		RGB(		255,	255,	255)		// Biay
	};

/////////////////////////////////////////////////////////////////////////////
// CMdiDoc construction/destruction

CMdiDoc::CMdiDoc()
{
	// TODO: add one-time construction code here

}

CMdiDoc::~CMdiDoc()
{
}

BOOL CMdiDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	 	//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------

		// Inicjalizacja koloru na czarny
		m_nKolor = ID_COLOR_BLACK - ID_COLOR_BLACK;

		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CMdiDoc serialization

void CMdiDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMdiDoc diagnostics

#ifdef _DEBUG
void CMdiDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMdiDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMdiDoc commands

	CLinia * CMdiDoc::DodajLinie(CPoint ptOd, CPoint ptDo)
	{
		// Utworzenie nowego obiektu klasy CLinia
		CLinia *pLinia = new CLinia(ptOd, ptDo, m_crKolory[m_nKolor]);
		try
		{
			// Dodanie nowego obiektu do tablicy
			m_oaLinie.Add(pLinia);
			// Zaznaczenie dokumentu jako "brudnego"
			SetModifiedFlag();
		}
		// Czy wystpi wyjtek pamici?
		catch (CMemoryException* perr)
		{
			// Poinformowanie uytkownika o wystpieniu wyjtku
			// pamici
			AfxMessageBox("Brak dostpnej pamici", MB_ICONSTOP | MB_OK);
			// Czy zosta utworzony obiekt linii?
			if (pLinia)
			{
				// Usunicie obiektu linii
				delete pLinia;
				pLinia = NULL;
			}
			// Usunicie obiektu wyjtku
			perr -> Delete();
		}
		return pLinia;
	}



	int CMdiDoc::PobierzLiczbeLini()
	{
		// Zwrcenie liczby elementw w tablicy
		return m_oaLinie.GetSize();
	}


	CLinia * CMdiDoc::PobierzLinie(int nIndex)
	{
		// Zwrcenie wskanika do obiektu linii znajdujcego
		// si w okrelonym miejscu w tablicy obiektw
		return (CLinia*)m_oaLinie[nIndex];
	}

void CMdiDoc::OnKolorCommand(UINT nID)
{
	// Ustawienie biecego koloru
	m_nKolor = nID - ID_COLOR_BLACK;
}

void CMdiDoc::OnUpdateColorUI(CCmdUI* pCmdUI)
{
	// Okrelenie, czy pole menu powinno by zaznaczone
	pCmdUI -> SetCheck(PobierzKolor() == pCmdUI->m_nID ? 1 : 0);
}

	UINT CMdiDoc::PobierzKolor()
	{
		// Zwrcenie wartoci aktualnego koloru
		return ID_COLOR_BLACK + m_nKolor;
	}


	void CMdiDoc::OnColorBlack()
	{
		// TODO: Add your command handler code here

 		//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------

		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_BLACK - ID_COLOR_BLACK;

		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------
	}


	void CMdiDoc::OnUpdateColorBlack(CCmdUI* pCmdUI)
	{
		// TODO: Add your command update UI handler code here
		
 		//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------

	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLACK ? 1 : 0);

		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------
	}


void CMdiDoc::OnColorBlue() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_BLUE - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorBlue(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLUE ? 1 : 0);
	
}

void CMdiDoc::OnColorCyan() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_CYAN - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorCyan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_CYAN ? 1 : 0);
	
}

void CMdiDoc::OnColorGreen() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_GREEN - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorGreen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_GREEN ? 1 : 0);
	
}

void CMdiDoc::OnColorMagenta() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_MAGENTA - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorMagenta(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_MAGENTA ? 1 : 0);
	
}

void CMdiDoc::OnColorRed() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_RED - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorRed(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_RED ? 1 : 0);
	
}

void CMdiDoc::OnColorWhite() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_WHITE - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorWhite(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_WHITE ? 1 : 0);
	
}

void CMdiDoc::OnColorYellow() 
{
	// TODO: Add your command handler code here
		// Ustawienie aktualnego koloru na czarny
		m_nKolor = ID_COLOR_YELLOW - ID_COLOR_BLACK;
	
}

void CMdiDoc::OnUpdateColorYellow(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	 	// Sprawdzenie czy pole menu Czarny powinno by zaznaczone
		pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_YELLOW ? 1 : 0);
	
}
