// ModArt.cpp: implementation of the CModArt class.
//
//////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <time.h>

#include "stdafx.h"
#include "Linia.h"
#include "ModArt.h"

extern "C" void PASCAL EXPORT ModArtCzyscRysunek(CObArray *poaLinie)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	// normal function body here

	// Pobranie iloci linii w tablicy obiektw
	int liLicznik= poaLinie->GetSize();
	int liPoz;

	// Czy w tablicy znajduj si jakiekolwiek obiekty?
	if (liLicznik)
	{
		// Ptla usuwajca wszystkie obiekty z tablicy
		for (liPoz = 0; liPoz < liLicznik; liPoz++)
			delete (*poaLinie)[liPoz];
		// Zresetowanie tablicy
		poaLinie->RemoveAll();
	}
}

extern "C" void PASCAL EXPORT ModArtRysuj(CDC *pDC, CObArray *poaLinie)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	// normal function body here

	// Pobranie liczby linii w tablicy obiektw
	int liLicznik= poaLinie->GetSize();
	int liPoz;

	// Czy w tablicy znajduj si jakie obiekty?
	if (liLicznik)
	{
		// Usuwanie rekordw w ptli dla caej tablicy
		for (liPoz = 0; liPoz < liLicznik; liPoz++)
			((CLinia*)(*poaLinie)[liPoz])->Rysuj(pDC);
	}
}

extern "C" void PASCAL EXPORT ModArtSerialize(CArchive &ar, CObArray *poaLinie)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	// normal function body here
	// Przekazanie obiektu archiwum do tablicy obiektw
	poaLinie->Serialize(ar);
}

extern "C" void PASCAL EXPORT ModArtNowyRysunek(CRect pObszar, CObArray *poaLinie)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	// normal function body here
	int lLiczbaLini;
	int lBiezacaLinia;

	//Zainicjalizowanie generatora liczb losowych
	srand((unsigned)time(NULL));
	// Okrelenie ile linii bdzie generowanych
	lLiczbaLini = rand() % 50;
	// Czy liczba linii do utworzenia przekracza 0?
	if (lLiczbaLini > 0)
	{
		// Ptla wykonywana dla wszystkich linii
		for (lBiezacaLinia = 0;lBiezacaLinia < lLiczbaLini;lBiezacaLinia++)
		{
			// Utworzenie nowej linii
			NowaLinia(pObszar, poaLinie);
		}
	}
}

void NowaLinia(CRect pObszar, CObArray *poaLinie)
{
	int lLiczbaLini;
	int lBiezacaLinia;
//	int nBiezacyKolor;
	UINT nBiezacaSzerokosc;
	CPoint pDo;
	CPoint pOd;
	int cCzerwony;
	int cNiebieski;
	int cZielony;

	// Normalizowanie obszaru przed okreleniem wysokoci i szerokoci
	pObszar.NormalizeRect();
	// pobranie szerokoci i wysokoi obszaru
	int lSzerokosc = pObszar.Width();
	int lWysokosc = pObszar.Height();

//COLORREF crKolory[8] = {
//		RGB(   0,   0,   0),	// Czarny
//		RGB(   0,   0, 255),	// Niebieski
//		RGB(   0, 255,   0),	// Zielony
//		RGB(   0, 255, 255),	// Bkitny
//		RGB( 255,   0,   0),	// Czerwony
//		RGB( 255,   0, 255),	// Fioletowy
//		RGB( 255, 255,   0),	// ty
//		RGB( 255, 255, 255)		// Biay
//	};

	// Okrelenie liczby elementw skadajcych si na wstg
	lLiczbaLini = rand() % 200;
	// Czy ustalona liczba elementw jest wiksza od 0?
	if (lLiczbaLini > 0)
	{
		// Okrelenie koloru
//		nBiezacyKolor = rand() % 8;
		cCzerwony = rand() % 255;
		cNiebieski = rand() % 255;
		cZielony = rand() % 255;
		// Okrelenie gruboci pira
		nBiezacaSzerokosc = (rand() % 8) + 1;
		// Okrelenie punktu startowego wstgi 
		pOd.x = (rand() % lSzerokosc) + pObszar.left;
		pOd.y = (rand() % lWysokosc) + pObszar.top;
		// Ptla wykonywana dla wszystkich segmentw linii
		for (lBiezacaLinia = 0;lBiezacaLinia < lLiczbaLini;lBiezacaLinia++)
		{
			// Okrelenie losowego punku kocowego segmentu
			pDo.x = ((rand() % 20) - 10) + pOd.x;
			pDo.y = ((rand() % 20) - 10) + pOd.y;
			// Utworzenie nowego obiektu linii
//			CLinia *pLine = new CLinia(pOd, pDo, nBiezacaSzerokosc, crKolory[nBiezacyKolor]);
			CLinia *pLine = new CLinia(pOd, pDo, nBiezacaSzerokosc, RGB(cCzerwony, cZielony, cNiebieski));
			try
			{
				// Dodanie nowego obiektu do tablicy
				poaLinie->Add(pLine);
			}
			// Czy nastpi wyjtek pamici ?
			catch (CMemoryException* perr)
			{
				// Wywietlenie komunikatu dla uytkownika
				// z informacj o powstaym bdzie
				AfxMessageBox("Brak dostpnej pamici", MB_ICONSTOP | MB_OK);
				// Czy utworzony zosta obiekt linii?
				if (pLine)
				{
					// Usunicie obiektu linii
					delete pLine;
					pLine = NULL;
				}
				// Usunicie obiektu wyjtku
				perr->Delete();
			}
			// Ustawienie punku startowego na punkt kocowy
			pOd = pDo;
		}
	}
}
