// SerializacjaDoc.cpp : implementation of the CSerializacjaDoc class
//

#include "stdafx.h"
#include "Serializacja.h"

#include "Osoba.h"
#include "SerializacjaDoc.h"
#include "SerializacjaView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaDoc

IMPLEMENT_DYNCREATE(CSerializacjaDoc, CDocument)

BEGIN_MESSAGE_MAP(CSerializacjaDoc, CDocument)
	//{{AFX_MSG_MAP(CSerializacjaDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaDoc construction/destruction

CSerializacjaDoc::CSerializacjaDoc()
{
	// TODO: add one-time construction code here

}

CSerializacjaDoc::~CSerializacjaDoc()
{
}

BOOL CSerializacjaDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	if (!DodajNowyRekord())
		return FALSE;
	// Pobranie wskanika do widoku 
	POSITION pos = GetFirstViewPosition();
	CSerializacjaView* pView = (CSerializacjaView*)GetNextView(pos);
	// Przekazanie widokowi informacji o nowym zestawie danych
	if (pView)
		pView->NowyZestawDanych();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CSerializacjaDoc serialization

void CSerializacjaDoc::Serialize(CArchive& ar)
{
	// Przekazanie serializacji do tablicy obiektw
	m_oaOsoby.Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaDoc diagnostics

#ifdef _DEBUG
void CSerializacjaDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSerializacjaDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaDoc commands

COsoba* CSerializacjaDoc::PobierzBierzacyRrd()
{
	// Czy przetwarzany jest prawidowy numer rekordu
	if (m_iAktualnaPozycja >= 0)
		// Tak, zwrcenie biecego rekordu
		return (COsoba*)m_oaOsoby[m_iAktualnaPozycja];
	else
		// Nie, zwrcenie wartoci NULL
		return NULL;
}

int CSerializacjaDoc::PobierzLiczbeRekordow()
{
	// Zwrcenie rozmiaru tablicy
	return m_oaOsoby.GetSize();
}

COsoba* CSerializacjaDoc::PobierzPierwszyRrd()
{
	// Czy w tablicy znajduj si jakiekolwiek rekordy?
	if (m_oaOsoby.GetSize() > 0)
	{
		// Tak, przejcie na pozycj 0
		m_iAktualnaPozycja = 0;
		// Zwrcenie zerowego rekordu 0
		return (COsoba*)m_oaOsoby[0];
	}
	else
		return NULL;
}

COsoba * CSerializacjaDoc::PobierzNastepnyRrd()
{
	// Czy po zwikszeniu wskanika pozycji, zosta przkroczony
	// zakres tablicy ?
	if (++m_iAktualnaPozycja < m_oaOsoby.GetSize())
		// Nie, zwrcenie rekordu z nowej, biecej pozycji
		return (COsoba*)m_oaOsoby[m_iAktualnaPozycja];
	else
		// Tak, dodanie nowego rekordu
		return DodajNowyRekord();
}

COsoba * CSerializacjaDoc::PobierzPoprzedniRrd()
{
	// Czy w tablicy znajduj si jakiekolwiek rekordy ?
	if (m_oaOsoby.GetSize() > 0)
	{
		// Czy po zmniejszeniu biecej pozycji o jeden
		// wypadnie ona poniej zera?
		if (--m_iAktualnaPozycja < 0)
			// Jeli tak, ustaw aktualn pozycj na 0
			m_iAktualnaPozycja = 0;
		// Zwrcenie rekordu z nowej, biecej pozcyji
		return (COsoba*)m_oaOsoby[m_iAktualnaPozycja];
	}
	else
		// Nie ma adnych rekordw, zwrcenie wartoci NULL
		return NULL;
}

COsoba * CSerializacjaDoc::PobierzOstatniRrd()
{
	// Czy w tablicy znajduj si jakiekolwiek rekordy?
	if (m_oaOsoby.GetSize() > 0)
	{
		// Tak, przejcie do ostatniej pozycji w tablicy
		m_iAktualnaPozycja = (m_oaOsoby.GetSize() - 1);
		// Zwrcenie rekordu z tej pozycji
		return (COsoba*)m_oaOsoby[m_iAktualnaPozycja];
	}
	else
		// Nie ma adnych rekordw, zwrcenie wartoci NULL
		return NULL;

}

COsoba * CSerializacjaDoc::DodajNowyRekord()
{
	// Utworzenie nowego rekordu osoby
	COsoba *pOsoba = new COsoba(this);
	try
	{
		// Dodanie nowej osoby do tablicy obiektw
		m_oaOsoby.Add(pOsoba);
		// Zaznaczenie dokumentu jako "brudnego"
		SetModifiedFlag();
		// Ustawienie aktualnej pozycji na nowej osobie
		m_iAktualnaPozycja = (m_oaOsoby.GetSize() - 1);
	}
	// Czy nastpi wyjtek pamici
	catch (CMemoryException* perr)
	{
		// Wywietlenie informacji o powstaym bdzie
		// pamici
		AfxMessageBox("Out of memory", MB_ICONSTOP | MB_OK);
		// Czy zosta utworzony obiekt?
		if (pOsoba)
		{
			// Usunicie obiektu
			delete pOsoba;
			pOsoba = NULL;
		}
		// Usunicie obiektu wyjtku
		perr->Delete();
	}
	return pOsoba;
}

void CSerializacjaDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie iloci elementw w tablicy
	int liLiczba = m_oaOsoby.GetSize();
	int liPoz;

	// Czy w tablicy znajduj si jakiekolwiek obiekty?
	if (liLiczba)
	{
		// Ptla usuwajca wszyskie obiekty z tablicy
		for (liPoz = 0; liPoz < liLiczba; liPoz++)
			delete m_oaOsoby[liPoz];
		// Wyzerowanie tablicy
		m_oaOsoby.RemoveAll();
	}

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

	CDocument::DeleteContents();
}

BOOL CSerializacjaDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	// TODO: Add your specialized creation code here

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie wskanika do widoku
	POSITION pos = GetFirstViewPosition();
	CSerializacjaView* pView = (CSerializacjaView*)GetNextView(pos);
	// Przekazanie widokowi informacji o nowym zestawie danych
	if (pView)
		pView->NowyZestawDanych();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
	
	return TRUE;
}
