// MdiView.cpp : implementation of the CMdiView class
//

#include "stdafx.h"
#include "Mdi.h"
#include "Linia.h"
#include "MdiDoc.h"
#include "MdiView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMdiView

IMPLEMENT_DYNCREATE(CMdiView, CView)

BEGIN_MESSAGE_MAP(CMdiView, CView)
	//{{AFX_MSG_MAP(CMdiView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMdiView construction/destruction

CMdiView::CMdiView()
{
	// TODO: add construction code here

}

CMdiView::~CMdiView()
{
}

BOOL CMdiView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMdiView drawing

void CMdiView::OnDraw(CDC* pDC)
{
	CMdiDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

	 	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------

		// Pobranie iloci linii w dokumencie
		int liLiczbaLini = pDoc -> PobierzLiczbeLini();
		
		// Czy w dokumencie s jakiekolwiek linie?
		if (liLiczbaLini)
		{
			int liPoz;
			CLinia *lptLinia;

			// Ptla wykonywana dla wszystkich linii w dokumencie
			for (liPoz = 0; liPoz <liLiczbaLini; liPoz++)
			{
				// Pobranie punktw Od i Do dla kadej linii
				lptLinia = pDoc -> PobierzLinie(liPoz);
				// Rysowanie linii
				lptLinia -> Rysuj(pDC);
			}
		}
	
		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

}

/////////////////////////////////////////////////////////////////////////////
// CMdiView printing

BOOL CMdiView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMdiView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMdiView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMdiView diagnostics

#ifdef _DEBUG
void CMdiView::AssertValid() const
{
	CView::AssertValid();
}

void CMdiView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMdiDoc* CMdiView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMdiDoc)));
	return (CMdiDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMdiView message handlers

	void CMdiView::OnLButtonDown(UINT nFlags, CPoint point)
	{
		// TODO: Add your message handler code here and/or call default

 		//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------

	// Przechwycenie myszy, tak aby adna inna aplikacja
		// nie moga z niej korzysta, kiedy opuci okno aplikacji
		SetCapture();
		// Zachowanie pozycji myszy
		m_ptOstatniaPoz = point;
		
		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------
	
		CView::OnLButtonDown(nFlags, point);
	}

	void CMdiView::OnLButtonUp(UINT nFlags, CPoint point)
	{
		// TODO: Add your message handler code here and/or call default

 		//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------
	
		// Czy mysz zostaa przechwycona?
		if (GetCapture() == this)
			// Jeeli tak, zwolni j, aby inne aplikacje mogy
			// z niej korzysta
			ReleaseCapture();

		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------

		CView::OnLButtonUp(nFlags, point);
	}

	void CMdiView::OnMouseMove(UINT nFlags, CPoint point)
	{
		// TODO: Add your message handler code here and/or call default

 		//-----------------------------------------
		// POCZTEK NOWEGO KODU RDOWEGO
		//-----------------------------------------
	
		// Sprawdzenie, czy lewy przycisk myszy jest przytrzymany
		if ((nFlags & MK_LBUTTON) == MK_LBUTTON)
		{
			// Czy zostaa przechwycona mysz?
			if (GetCapture() == this)
			{
				// Pobranie kontekstu urzdzenia
			CClientDC dc(this);
			
				// Dodanie linii do dokumentu
				CLinia *pLinia = GetDocument() -> DodajLinie(m_ptOstatniaPoz, point);

				// Rysowanie aktualnej linii
				pLinia -> Rysuj(&dc);
				
				// Zapisanie aktualnej pozycji jako poprzedniej
				m_ptOstatniaPoz = point;
			}
		}

		//-----------------------------------------
		// KONIEC NOWEGO KODU RDOWEGO
		//-----------------------------------------

		CView::OnMouseMove(nFlags, point);
	}


void CMdiView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// TODO: Add your message handler code here
	
	CMenu menu;

	// Zaadowanie menu kontekstowego
	menu.LoadMenu(IDR_CONTEXTMENU);
	// Pobranie pierwszego podmenu (rzeczywistego menu)
	CMenu * pContextMenu = menu.GetSubMenu(0);

	// Wywietlenie menu kontekstowego na ekranie
		pContextMenu->TrackPopupMenu(TPM_LEFTALIGN | 
			TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
			point.x, point.y, AfxGetMainWnd());
}
