// Linia.cpp: implementation of the CLinia class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Linia.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_SERIAL (CLinia, CObject, 1)
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLinia::CLinia()
{

}

CLinia::~CLinia()
{

}

CLinia::CLinia(CPoint ptOd, CPoint ptDo)
{
	// Inicjalizacja generatora liczb losowych
	m_ptOd = ptOd;
	m_ptDo = ptDo;
	m_nSzerokosc = 16;
	m_crKolor = RGB(0, 0, 0);
}

CPoint * CLinia::PobierzOd()
{
	// Zwrcenie wartoci punku Od
	return &m_ptOd;
}

CPoint * CLinia::PobierzDo()
{	
	// Zwrcenie wartoci punktu Do
	return &m_ptDo;
}

void CLinia::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	if (ar.IsStoring())
		ar << m_ptOd << m_ptDo << m_nSzerokosc << (DWORD) m_crKolor;
	else
		ar >> m_ptOd >> m_ptDo >> m_nSzerokosc >> (DWORD) m_crKolor;
}

void CLinia::Rysuj(CDC * pDC)
{
	// Utworzenie pira
	CPen lpen (PS_SOLID, m_nSzerokosc, m_crKolor);

	// Ustawienie nowego pira jako obiektu rysujcego
	CPen* pOldPen = pDC->SelectObject(&lpen);
	// Rysowanie linii
	pDC->MoveTo(m_ptOd);
	pDC->LineTo(m_ptDo);
	// Zresetowanie poprzedniego pira
	pDC->SelectObject(pOldPen);
}

CLinia::CLinia(CPoint ptOd, CPoint ptDo, UINT nSzerokosc, COLORREF crColor)
{
	m_ptOd = ptOd;
	m_ptDo = ptDo;
	m_nSzerokosc = nSzerokosc;
	m_crKolor = crColor;
}
