// DbAdoDoc.cpp : implementation of the CDbAdoDoc class
//

#include "stdafx.h"
#include "DbAdo.h"

#include "CustomRS.h"
#include "DbAdoDoc.h"
#include "DbAdoView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDbAdoDoc

IMPLEMENT_DYNCREATE(CDbAdoDoc, CDocument)

BEGIN_MESSAGE_MAP(CDbAdoDoc, CDocument)
	//{{AFX_MSG_MAP(CDbAdoDoc)
	ON_UPDATE_COMMAND_UI(IDM_DATA_FIRST, OnUpdateDataFirst)
	ON_UPDATE_COMMAND_UI(IDM_DATA_LAST, OnUpdateDataLast)
	ON_UPDATE_COMMAND_UI(IDM_DATA_NEXT, OnUpdateDataNext)
	ON_UPDATE_COMMAND_UI(IDM_DATA_PREV, OnUpdateDataPrev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDbAdoDoc construction/destruction

CDbAdoDoc::CDbAdoDoc()
{
	// TODO: add one-time construction code here
	m_piAdoRecordBinding = NULL;
	m_pRs = NULL;

}

CDbAdoDoc::~CDbAdoDoc()
{
}

BOOL CDbAdoDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	// Ustawienie cuchw SQL i poczenia
	m_strPolaczenie = _T("Provider=MSDASQL.1;Data Source=NSVCBD");
	m_strPolecenieSQL = _T("select * from Adresy");

	// / Inicjalizacja wskanikw
	m_pRs = NULL;
	m_piAdoRecordBinding = NULL;
	// Inicjalizacja rodowiska COM
	::CoInitialize(NULL);
	try
	{
		// Utworzenie obiektu zbioru rekordw
		m_pRs.CreateInstance(__uuidof(Recordset));

		// Otwarcie obiektu zbioru rekordw
		m_pRs->Open((LPCTSTR)m_strPolecenieSQL, (LPCTSTR)m_strPolaczenie, adOpenDynamic,
			adLockOptimistic, adCmdUnknown);

		// Pobranie wskanika do interfejsu bindujcego rekordy
		if (FAILED(m_pRs->QueryInterface(__uuidof(IADORecordBinding), (LPVOID *)&m_piAdoRecordBinding)))
			_com_issue_error(E_NOINTERFACE);
		// Poczenie klasy rekordu ze zbiorem rekordw
		m_piAdoRecordBinding->BindToRecordset(&m_rsZbiorR);

		// Pobranie wskanika do widoku
		POSITION pos = GetFirstViewPosition();
		CDbAdoView* pView = (CDbAdoView*)GetNextView(pos);
		if (pView)
			// Synchronizowanie zbioru danych z formularzem
			pView->OdswiezDolaczoneDane();
	}
	// Czy powstay jakie bdy
	catch (_com_error &e)
	{
		// Wywietlenie bdu
		GenerujBlad(e.Error(), e.Description());
	}

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CDbAdoDoc serialization

void CDbAdoDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDbAdoDoc diagnostics

#ifdef _DEBUG
void CDbAdoDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDbAdoDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDbAdoDoc commands

void CDbAdoDoc::PrzejdzPierwszy()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Przejcie do pierwszego rekordu
		m_pRs->MoveFirst();
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Wygenerowanie inforamcji o bdzie
		GenerujBlad(e.Error(), e.Description());
	}
}

void CDbAdoDoc::PrzejdzPoprzedni()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Przejcie do poprzedniego rekordu
		m_pRs->MovePrevious();
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Wygenerowanie inforamcji o bdzie
		GenerujBlad(e.Error(), e.Description());
	}
}

void CDbAdoDoc::PrzejdzNastepny()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Przejcie do nastpnego rekordu
		m_pRs->MoveNext();
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Wygenerowanie inforamcji o bdzie
		GenerujBlad(e.Error(), e.Description());
	}
}

void CDbAdoDoc::PrzejdzOstatni()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Przejcie go poprzedniego rekordu
		m_pRs->MoveLast();
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Wygenerowanie inforamcji o bdzie
		GenerujBlad(e.Error(), e.Description());
	}
}

CCustomRs* CDbAdoDoc::GetRecSet()
{
		// Zwrcenie wskanika do obiektu zbioru rekordw
		return &m_rsZbiorR;

}

void CDbAdoDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
	// Zamknicie zbioru rekordw
	if (m_pRs)
		m_pRs->Close();
	// Czy wskanik do bindujcego czcego jest prawidowy?
	if (m_piAdoRecordBinding)
		// Zwolnienie wskanika
		m_piAdoRecordBinding->Release();
	// Ustawienie wskanika zbioru rekordw na NULL
	m_pRs = NULL;

	// Zamknicie rodowiska COM
	CoUninitialize();

	CDocument::DeleteContents();
}

void CDbAdoDoc::GenerujBlad(HRESULT hr, PWSTR pwszOpis)
{
	CString strBlad;

	// Formatowanie i wywietlenie komunikatu o bdzie
	strBlad.Format("Bd w czasie pracy '%d (%x)'", hr, hr);
	strBlad += "\n\n";
	strBlad += pwszOpis;

	AfxMessageBox(strBlad);
}

void CDbAdoDoc::DodajNowy()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Czy mona doda nowy rekord?
		if (m_pRs->Supports(adAddNew))
		{
			// Utworznie pustego rekordu
			TworzPustyRekord();
			// Dodanie pustego rekordu do zbioru
			m_piAdoRecordBinding->AddNew(&m_rsZbiorR);
			// Przejcie do ostatniego rekordu
			m_pRs->MoveLast();
		}
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Generowanie informacji o bdzie
		GenerujBlad(e.Error(), e.Description());
	}
}

void CDbAdoDoc::Usun()
{
	try
	{
		// Uaktualnienie biecego rekordu
		m_piAdoRecordBinding->Update(&m_rsZbiorR);
		// Czy rekord mona usun?
		if (m_pRs->Supports(adDelete))
		{
			// Weryfikacja polecenia przez uytkownika
			if (AfxMessageBox("Czy rzeczywicie chcesz usun ten rekord?",
					//"Usun rekord?", MB_YESNO | MB_ICONQUESTION) == IDYES)
					MB_YESNO | MB_ICONQUESTION) == IDYES)
			{
				// Usunicie rekordu
				m_pRs->Delete(adAffectCurrent);
				// Przejcie do poprzedniego rekordu
				m_pRs->MovePrevious();
			}
		}
	}
	// Jakie bdy?
	catch (_com_error &e)
	{
		// Wywietlenie bdu
		GenerujBlad(e.Error(), e.Description());
	}
}

void CDbAdoDoc::TworzPustyRekord()
{
	// Utworzenie pustych wartoi do uytku poniej
	CString strPusty = " ";
	COleDateTime dtPusty;

	// Ustawienie wszystkich wartoci wystpujcych w rekordzie
	m_rsZbiorR.m_lAdresID = 0;
	strcpy(m_rsZbiorR.m_szImie, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szNazwisko, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szImieMalzonka, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szAdres, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szMiasto, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szStanlubProwincja, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szKodPocztowy, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szKraj, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szAdresEmail, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szTelefonDomowy, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szTelSluzbowy, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szWewnetrzny, (LPCTSTR)strPusty);
	strcpy(m_rsZbiorR.m_szNumerFaksu, (LPCTSTR)strPusty);
	m_rsZbiorR.m_dtDataUR = (DATE)dtPusty;
	m_rsZbiorR.m_bKartaWysylki = VARIANT_FALSE;
	strcpy(m_rsZbiorR.m_szUwagi, (LPCTSTR)strPusty);
}

void CDbAdoDoc::OnUpdateDataFirst(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	// Czy rekord istnieje?
	if (m_pRs)
	{
		// Czy aktualn pozycj jest BOF?
		if (m_pRs->BOF)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}
}

void CDbAdoDoc::OnUpdateDataLast(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	// Czy rekord istnieje?
	if (m_pRs)
	{
		// Czy aktualn pozycj jest EOF?
		if (m_pRs->EndOfFile)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}
}

void CDbAdoDoc::OnUpdateDataNext(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	// Czy rekord istnieje?
	if (m_pRs)
	{
		// Czy aktualn pozycj jest EOF?
		if (m_pRs->EndOfFile)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}
}

void CDbAdoDoc::OnUpdateDataPrev(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	// Czy rekord istnieje?
	if (m_pRs)
	{
		// Czy aktualn pozycj jest BOF?
		if (m_pRs->BOF)
			pCmdUI->Enable(FALSE);
		else
			pCmdUI->Enable(TRUE);
	}
}
