// SerializacjaView.cpp : implementation of the CSerializacjaView class
//

#include "stdafx.h"
#include "Serializacja.h"

#include "Osoba.h"
#include "SerializacjaDoc.h"
#include "SerializacjaView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSerializacjaView

IMPLEMENT_DYNCREATE(CSerializacjaView, CFormView)

BEGIN_MESSAGE_MAP(CSerializacjaView, CFormView)
	//{{AFX_MSG_MAP(CSerializacjaView)
	ON_BN_CLICKED(IDC_PPIERWSZY, OnPpierwszy)
	ON_BN_CLICKED(IDC_POSTATNI, OnPostatni)
	ON_BN_CLICKED(IDC_PNASTEPNY, OnPnastepny)
	ON_BN_CLICKED(IDC_PPOPRZEDNI, OnPpoprzedni)
	ON_BN_CLICKED(IDC_POZATRUDNIONY, OnPozatrudniony)
	ON_EN_CHANGE(IDC_EWIEK, OnChangeEage)
	ON_EN_CHANGE(IDC_ENAZWISKO, OnChangeEname)
	ON_BN_CLICKED(IDC_OROZWIEDZIONY, OnStat)
	ON_BN_CLICKED(IDC_OZONATY, OnStat)
	ON_BN_CLICKED(IDC_OKAWALER, OnStat)
	ON_BN_CLICKED(IDC_OWDOWIEC, OnStat)
	ON_BN_CLICKED(IDC_PFACET, OnSex)
	ON_BN_CLICKED(IDC_PKOBIETA, OnSex)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaView construction/destruction

CSerializacjaView::CSerializacjaView()
	: CFormView(CSerializacjaView::IDD)
{
	//{{AFX_DATA_INIT(CSerializacjaView)
	m_bZatrudiony = FALSE;
	m_iWiek = 0;
	m_sNazwisko = _T("");
	m_iStanCywilny = -1;
	m_iPlec = -1;
	m_sPozycja = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CSerializacjaView::~CSerializacjaView()
{
}

void CSerializacjaView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSerializacjaView)
	DDX_Check(pDX, IDC_POZATRUDNIONY, m_bZatrudiony);
	DDX_Text(pDX, IDC_EWIEK, m_iWiek);
	DDX_Text(pDX, IDC_ENAZWISKO, m_sNazwisko);
	DDX_Radio(pDX, IDC_OKAWALER, m_iStanCywilny);
	DDX_Radio(pDX, IDC_PFACET, m_iPlec);
	DDX_Text(pDX, IDC_SPOSITION, m_sPozycja);
	//}}AFX_DATA_MAP
}

BOOL CSerializacjaView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CSerializacjaView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

}

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaView printing

BOOL CSerializacjaView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CSerializacjaView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CSerializacjaView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CSerializacjaView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add code to print the controls
}

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaView diagnostics

#ifdef _DEBUG
void CSerializacjaView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSerializacjaView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSerializacjaDoc* CSerializacjaView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSerializacjaDoc)));
	return (CSerializacjaDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSerializacjaView message handlers

void CSerializacjaView::WypelnijWidok()
{
	// Pobranie wskanika do biecego dokumentu
	CSerializacjaDoc* pDoc = GetDocument();
	if (pDoc)
	{
		// Wywietlenie biecej pozycji w zestawie
		m_sPozycja.Format("Record %d z %d", pDoc->PobierzNrBRekordu(), pDoc->PobierzLiczbeRekordow());
	}
	// Czy wskazanie do obiektu jest prawidowe?
	if (m_pAktualnaOsoba)
	{
		// Tak, pobranie wszyskich wartoci rekordu
		m_bZatrudiony = m_pAktualnaOsoba->PobierzZatrudniony();
		m_iWiek = m_pAktualnaOsoba->PobierzWiek();
		m_sNazwisko = m_pAktualnaOsoba->PobierzNazwisko();
		m_iStanCywilny = m_pAktualnaOsoba->PobierzStanCywilny();
		m_iPlec = m_pAktualnaOsoba->PobierzPlec();
	}
	// Uaktualnienie wartoci wywietlanych na formularzu
	UpdateData(FALSE);
}

void CSerializacjaView::OnPpierwszy() 
{
	// TODO: Add your control notification handler code here

	// Pobranie wskanika do biecego dokumentu
	CSerializacjaDoc * pDoc = GetDocument();
	if (pDoc)
	{
		// Pobranie pierwszego rekordu z dokumentu
		m_pAktualnaOsoba = pDoc->PobierzPierwszyRrd();
		if (m_pAktualnaOsoba)
		{
			// Wywietlenie aktulnego rekordu
			WypelnijWidok();
		}
	}
}

void CSerializacjaView::OnPostatni() 
{
	// TODO: Add your control notification handler code here

	// Pobranie wskanika do biecego dokumentu
	CSerializacjaDoc * pDoc = GetDocument();
	if (pDoc)
	{
		// Pobranie ostatniego rekordu z dokumentu
		m_pAktualnaOsoba = pDoc->PobierzOstatniRrd();
		if (m_pAktualnaOsoba)
		{
			// Wywietlenie biecego rekordu
			WypelnijWidok();
		}
	}
}

void CSerializacjaView::OnPnastepny() 
{
	// TODO: Add your control notification handler code here
	CSerializacjaDoc * pDoc = GetDocument();
	if (pDoc)
	{
		m_pAktualnaOsoba = pDoc->PobierzNastepnyRrd();
		if (m_pAktualnaOsoba)
		{
			WypelnijWidok();
		}
	}
}

void CSerializacjaView::OnPpoprzedni() 
{
	// TODO: Add your control notification handler code here
	CSerializacjaDoc * pDoc = GetDocument();
	if (pDoc)
	{
		m_pAktualnaOsoba = pDoc->PobierzPoprzedniRrd();
		if (m_pAktualnaOsoba)
		{
			WypelnijWidok();
		}
	}
}

void CSerializacjaView::OnPozatrudniony() 
{
	// TODO: Add your control notification handler code here

	// Zsynchronizowanie danych z formularza ze zmiennymi
	UpdateData(TRUE);
	// Jeeli obiekt osoba jest prawidowy, przelij do niego zmiany
	if (m_pAktualnaOsoba)
		m_pAktualnaOsoba->UstawZatrudniony(m_bZatrudiony);
}

void CSerializacjaView::OnChangeEage() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitialUpdate()
	// function and call CRichEditCrtl().SetEventMask()
	// with the EN_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if (m_pAktualnaOsoba)
		m_pAktualnaOsoba->UstawWiek(m_iWiek);
}

void CSerializacjaView::OnChangeEname() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitialUpdate()
	// function and call CRichEditCrtl().SetEventMask()
	// with the EN_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if (m_pAktualnaOsoba)
		m_pAktualnaOsoba->UstawNazwisko(m_sNazwisko);
}

void CSerializacjaView::OnStat() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if (m_pAktualnaOsoba)
		m_pAktualnaOsoba->UstawStanCywilny(m_iStanCywilny);
}

void CSerializacjaView::NowyZestawDanych()
{
	// Wywietlenie pierwszego rekordu w zestawie
	OnPpierwszy();
}

void CSerializacjaView::OnSex() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if (m_pAktualnaOsoba)
		m_pAktualnaOsoba->UstawPlec(m_iPlec);
}
