// SdiDoc.cpp : implementation of the CSdiDoc class
//

#include "stdafx.h"
#include "Sdi.h"
#include "MainFrm.h"
#include "Linia.h"
#include "SdiDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSdiDoc

IMPLEMENT_DYNCREATE(CSdiDoc, CDocument)

BEGIN_MESSAGE_MAP(CSdiDoc, CDocument)
	ON_UPDATE_COMMAND_UI(ID_INDYKATOR_KOLOR, OnUpdateIndykatorKolor)
	//{{AFX_MSG_MAP(CSdiDoc)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_VTHIN, OnUpdateSzerokoscBCienki)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_VTHICK, OnUpdateSzerokoscBGruby)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_THIN, OnUpdateSzerokoscCienki)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_THICK, OnUpdateSzerokoscGruby)
	ON_UPDATE_COMMAND_UI(ID_WIDTH_MEDIUM, OnUpdateSzerokoscSredni)
	ON_UPDATE_COMMAND_UI(ID_COLOR_YELLOW, OnUpdateColorYellow)
	ON_UPDATE_COMMAND_UI(ID_COLOR_WHITE, OnUpdateColorWhite)
	ON_UPDATE_COMMAND_UI(ID_COLOR_RED, OnUpdateColorRed)
	ON_UPDATE_COMMAND_UI(ID_COLOR_MAGENTA, OnUpdateColorMagenta)
	ON_UPDATE_COMMAND_UI(ID_COLOR_GREEN, OnUpdateColorGreen)
	ON_UPDATE_COMMAND_UI(ID_COLOR_CYAN, OnUpdateColorCyan)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLUE, OnUpdateColorBlue)
	ON_UPDATE_COMMAND_UI(ID_COLOR_BLACK, OnUpdateColorBlack)
	ON_COMMAND(ID_COLOR_BLACK, OnColorBlack)
	ON_COMMAND(ID_COLOR_BLUE, OnColorBlue)
	ON_COMMAND(ID_COLOR_CYAN, OnColorCyan)
	ON_COMMAND(ID_COLOR_GREEN, OnColorGreen)
	ON_COMMAND(ID_COLOR_MAGENTA, OnColorMagenta)
	ON_COMMAND(ID_COLOR_RED, OnColorRed)
	ON_COMMAND(ID_COLOR_WHITE, OnColorWhite)
	ON_COMMAND(ID_COLOR_YELLOW, OnColorYellow)
	ON_COMMAND(ID_WIDTH_MEDIUM, OnSzerokoscSredni)
	ON_COMMAND(ID_WIDTH_THICK, OnSzerokoscGruby)
	ON_COMMAND(ID_WIDTH_THIN, OnSzerokoscCienki)
	ON_COMMAND(ID_WIDTH_VTHICK, OnSzerokoscBGruby)
	ON_COMMAND(ID_WIDTH_VTHIN, OnSzerokoscBCienki)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

const COLORREF CSdiDoc::m_crKolory[8] = {
	RGB(   0,   0,   0),	// Czarny
	RGB(   0,   0, 255),	// Niebieski
	RGB(   0, 255,   0),	// Zielony
	RGB(   0, 255, 255),	// Bkitny
	RGB( 255,   0,   0),	// Czerwony
	RGB( 255,   0, 255),	// Fioletowy
	RGB( 255, 255,   0),	// ty
	RGB( 255, 255, 255)		// Biay
};

/////////////////////////////////////////////////////////////////////////////
// CSdiDoc construction/destruction

CSdiDoc::CSdiDoc()
{
	// TODO: add one-time construction code here

}

CSdiDoc::~CSdiDoc()
{
}

BOOL CSdiDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Inicjalizacja koloru na czarny
	m_nKolor = ID_COLOR_BLACK - ID_COLOR_BLACK;
	m_nSzerokosc = ID_WIDTH_MEDIUM - ID_WIDTH_VTHIN;
	UaktualnijPasek(m_nSzerokosc);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CSdiDoc serialization

void CSdiDoc::Serialize(CArchive& ar)
{
	// Przekazanie serializacji do tablicy obiektw
	m_oaLinie.Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CSdiDoc diagnostics

#ifdef _DEBUG
void CSdiDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSdiDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSdiDoc commands

int CSdiDoc::PobierzLiczbeLini()
{
	// Zwrcenie liczby elementw w tablicy
	return m_oaLinie.GetSize();
}

CPoint* CSdiDoc::PobierzDo(int nIndex)
{

	// Zwrcenie wskanika do punktu "Do" znajdujcego
	// w obiekcie CLinia na okrelonej pozycji w tablicy
	// obiektw 
	return ((CLinia*)m_oaLinie[nIndex])->PobierzDo();
}

CPoint* CSdiDoc::PobierzOd(int nIndex)
{
	// Zwrcenie wskanika do punktu "Od" znajdujcego
	// w obiekcie CLinia na okrelonej pozycji w tablicy
	// obiektw 
	return ((CLinia*)m_oaLinie[nIndex])->PobierzOd();
}

CLinia * CSdiDoc::DodajLinie(CPoint ptOd, CPoint ptDo)
{
	static UINT nSzerokosci[5] = { 1, 8, 16, 24, 32};

	// Utworzenie nowego obiektu klasy CLinia
	CLinia *pLinia = new CLinia(ptOd, ptDo, nSzerokosci[m_nSzerokosc], m_crKolory[m_nKolor]);
	try
	{
		// Dodanie nowego obiektu do tablicy
		m_oaLinie.Add(pLinia);
		// Zaznaczenie dokumentu jako "brudnego"
		SetModifiedFlag();
	}
	// Czy wystpi wyjtek pamici?
	catch (CMemoryException* perr)
	{
		// Poinformowanie uytkownika o wystpieniu wyjtku
		// pamici
		AfxMessageBox("Brak wolnej pamici", MB_ICONSTOP | MB_OK);
		// Czy zosta utworzony obiekt linii?
		if (pLinia)
		{
			// Usunicie obiektu linii
			delete pLinia;
			pLinia = NULL;
		}
		// Usunicie obiektu wyjtku
		perr->Delete();
	}
	return pLinia;
}

void CSdiDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie liczby linii w tablicy obiektw
	int liLiczbaLinii = m_oaLinie.GetSize();
	int iPoz;

	// Czy w tablicy znajduj si jakiekolwiek linie?
	if (liLiczbaLinii)
	{
		// Ptla usuwajca wszystkie obiekty z tablicy
		for (iPoz = 0; iPoz < liLiczbaLinii; iPoz++)
			delete m_oaLinie[iPoz];
		// Wyzerowanie tablicy
		m_oaLinie.RemoveAll();
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CDocument::DeleteContents();
}

CLinia * CSdiDoc::PobierzLinie(int nIndex)
{
	// Zwrcenie wskanika do obiektu linii znajdujcego
	// si w okrelonym miejscu w tablicy obiektw
	return (CLinia*)m_oaLinie[nIndex];
}

UINT CSdiDoc::PobierzKolor()
{
	// Zwrcenie wartoci aktualnego koloru
	return ID_COLOR_BLACK + m_nKolor;
}

UINT CSdiDoc::PobierzSzerokosc()
{
	// Zwrcenie biecej grubosci pira
	return ID_WIDTH_VTHIN + m_nSzerokosc;
}

void CSdiDoc::OnUpdateSzerokoscBCienki(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_VTHIN ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_VTHIN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateSzerokoscBGruby(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_VTHICK ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_VTHICK ? 1 : 0);

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateSzerokoscCienki(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_THIN ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_THIN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateSzerokoscGruby(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_THICK ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_THICK ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateSzerokoscSredni(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzSzerokosc() == ID_WIDTH_MEDIUM ? 1 : 0);
	pCmdUI->SetRadio(PobierzSzerokosc() == ID_WIDTH_MEDIUM ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorYellow(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_YELLOW ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_YELLOW ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorWhite(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_WHITE ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_WHITE ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorRed(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_RED ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_RED ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorMagenta(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_MAGENTA ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_MAGENTA ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorGreen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_GREEN ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_GREEN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorCyan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_CYAN ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_CYAN ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorBlue(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLUE ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_BLUE ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnUpdateColorBlack(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Sprawdzenie, czy okrelone pole menu powinno by aktywne
//	pCmdUI->SetCheck(PobierzKolor() == ID_COLOR_BLACK ? 1 : 0);
	pCmdUI->SetRadio(PobierzKolor() == ID_COLOR_BLACK ? 1 : 0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorBlack() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na czarny
	m_nKolor = 0;	

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorBlue() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na niebieski
	m_nKolor = 1;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorCyan() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na bkitny
	m_nKolor = 3;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorGreen() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na zielony
	m_nKolor = 2;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorMagenta() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na fioletowy
	m_nKolor = 5;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorRed() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na czerwony
	m_nKolor = 4;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorWhite() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na biay
	m_nKolor = 7;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnColorYellow() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie aktualnego koloru na ty
	m_nKolor = 6;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnSzerokoscSredni() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na redni
	m_nSzerokosc = 2;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(2);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnSzerokoscGruby() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na grub
	m_nSzerokosc = 3;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(3);

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnSzerokoscCienki() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na ciank
	m_nSzerokosc = 1;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(1);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnSzerokoscBGruby() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na bardzo grub
	m_nSzerokosc = 4;

	// Uaktualnienie paska kolorw
	UaktualnijPasek(4);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::OnSzerokoscBCienki() 
{
	// TODO: Add your command handler code here

	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Ustawienie biecej gruboci na bardzo cienk
	m_nSzerokosc = 0;
	// Uaktualnienie paska kolorw
	UaktualnijPasek(0);

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

void CSdiDoc::UstawSzerokosc(int nIndex)
{
	// Ustawienie biecej gruboci
	m_nSzerokosc = nIndex;
}


void CSdiDoc::UaktualnijPasek(int nIndex)
{
	// Pobranie pozycji pierwszego widoku
	POSITION poz = GetFirstViewPosition();
	// Czy pobrana zostaa prawidowa pozycja?
	if (poz != NULL)
	{
		// Utworzenie wskanika do widoku na tej pozycji
		CView* pView = GetNextView(poz);
		// Czy utworzone zostao prawidowe wskazanie?
		if (pView)
		{
			// Pobranie wkazania do ramki poprzez widok
			CMainFrame* pFrame = (CMainFrame*)pView->GetTopLevelFrame();
			// Sprawdzenie czy wskazanie jest poprawne
			if (pFrame)
				// Uaktualnienie obiektu kombi poprzez ramk
				pFrame->UaktualnijGruboscCB(nIndex);
		}
	}
}

void CSdiDoc::OnUpdateIndykatorKolor(CCmdUI *pCmdUI)
{
	CString strColor;

	switch (m_nKolor)
	{
	case 0:
		strColor = "CZARNY";
		break;
	case 1:
		strColor = "NIEBIESKI";
		break;
	case 2:
		strColor = "ZIELONY";
		break;
	case 3:
		strColor = "BKITNY";
		break;
	case 4:
		strColor = "CZERWONY";
		break;
	case 5:
		strColor = "FIOLETOWY";
		break;
	case 6:
		strColor = "ӣTY";
		break;
	case 7:
		strColor = "BIAY";
		break;
	}
	pCmdUI->Enable(TRUE);
	pCmdUI->SetText(strColor);
}
