// Linia.cpp: implementation of the CLinia class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Sdi.h"
#include "Linia.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_SERIAL (CLinia, CObject, 1)
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLinia::CLinia()
{

}

CLinia::~CLinia()
{

}

CLinia::CLinia(CPoint ptOd, CPoint ptDo)
{
	//// Inicjalizacja punktw Od i Do
	m_ptOd = ptOd;
	m_ptDo = ptDo;
	m_nSzerokosc = 16;
	m_crKolor = RGB(0, 0, 0);
}

CPoint * CLinia::PobierzOd()
{
	// Zwrcenie punktu m_ptOd
	return &m_ptOd;
}

CPoint * CLinia::PobierzDo()
{	
	// Zwrcenie punktu m_ptDo
	return &m_ptDo;
}

void CLinia::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	if (ar.IsStoring())
		ar << m_ptOd << m_ptDo << m_nSzerokosc << (DWORD) m_crKolor;
	else
		ar >> m_ptOd >> m_ptDo >> m_nSzerokosc >> (DWORD) m_crKolor;
}

void CLinia::Rysuj(CDC * pDC)
{
	// Utworzenie pira
	CPen lpioro (PS_SOLID, m_nSzerokosc, m_crKolor);

	// Ustawienie nowego pira jako obiektu rysujcego
	CPen* pStarePioro = pDC->SelectObject(&lpioro);
	// Rysowanie linii
	pDC->MoveTo(m_ptOd);
	pDC->LineTo(m_ptDo);
	// Zresetowanie poprzedniego pira
	pDC->SelectObject(pStarePioro);
}

CLinia::CLinia(CPoint ptOd, CPoint ptDo, UINT nSzerokosc, COLORREF crKolor)
{
	// Inicjalizacja punktw Od i Do
	m_ptOd = ptOd;
	m_ptDo = ptDo;
	m_nSzerokosc = nSzerokosc;
	m_crKolor = crKolor;
}

