// ActiveXDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ActiveX.h"
#include "ActiveXDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CActiveXDlg dialog

CActiveXDlg::CActiveXDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CActiveXDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CActiveXDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CActiveXDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CActiveXDlg)
	DDX_Control(pDX, IDC_MSFGRID, m_ctlFGrid);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CActiveXDlg, CDialog)
	//{{AFX_MSG_MAP(CActiveXDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CActiveXDlg message handlers

BOOL CActiveXDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Zaadowanie danych do siatki kontrolki
	LadujDane();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CActiveXDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CActiveXDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CActiveXDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CActiveXDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Zamknicie okna
	OnOK();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CActiveXDlg::LadujDane()
{
	int iLicznik;		// Licznik wierszy siatki
	CString strWartosc;	// Wartosc sprzeday

	// Inicjalizacja generatora liczb losowych
	srand((unsigned)time(NULL));
	// Ptla wypeniajca siakt komrek kontrolki ActiveX
	for (iLicznik = m_ctlFGrid.GetFixedRows(); 
		iLicznik < m_ctlFGrid.GetRows(); iLicznik++)
	{
		// Generacja wartoci dla pierwszej kolumny (region)
		m_ctlFGrid.SetTextArray(GenerujID(iLicznik, 0), LosowaWartoscLancuchowa(0));
		// Generacja wartoci dla drugiej kolumny (produkt)
		m_ctlFGrid.SetTextArray(GenerujID(iLicznik, 1), LosowaWartoscLancuchowa(1));
		// Generacja wartoci dla trzeciej kolumny (pracownik)
		m_ctlFGrid.SetTextArray(GenerujID(iLicznik, 2), LosowaWartoscLancuchowa(2));
		// Generacja wartoci sprzeday
		strWartosc.Format("%5d.00", rand());
		// Wypenienie czwartej kolumny
		m_ctlFGrid.SetTextArray(GenerujID(iLicznik, 3), strWartosc);
	}

	// Poczenie ssiadujcych komrek zawierajcych t sam warto
	m_ctlFGrid.SetMergeCol(0, TRUE);
	m_ctlFGrid.SetMergeCol(1, TRUE);
	m_ctlFGrid.SetMergeCol(2, TRUE);

	// Sortowanie siatki
	Sortuj();
}

int CActiveXDlg::GenerujID(int aiRow, int m_iKol)
{
	// Pobranie liczby kolum
	int iKolumny = m_ctlFGrid.GetCols();

	// Generowanie identyfikatora ID na podstawie licznby kolumn
	// biecej kolumny i biecego rzdu
	return (m_iKol + iKolumny * aiRow);
}


CString CActiveXDlg::LosowaWartoscLancuchowa(int m_iKol)
{
	CString strStr;	// Warto zwracana prze funkcj
	int iCase;		//losowa warto identyfikatora ID

	// Wybr kolumny dla ktrej generowane bd dane
	switch (m_iKol)
	{
	case 0:	// Pierwsza kolumna (region)
		// Generacja wartoci losowej pomidzy 0 i 4
		iCase = (rand() % 5);
		// Jaka warto zostaa wygenerowana?
		switch (iCase)
		{
		case 0:
			// 0 - Region pnocno-zachodni
			strStr = "Pnocno-zachodni";
			break;
		case 1:
			// 1 - Region poudniowo-zachodni
			strStr = "Poudniowo-zachodni";
			break;
		case 2:
			// 2 - Region rodkowo zachodni
			strStr = "rodkowo zachodni";
			break;
		case 3:
			// 3 - Region pnocno-wschodni
			strStr = "Pnocno-wschodni";
			break;
		default:
			// 4 - Region poudniowo-wschodni
			strStr = "Poudniowo-wschodni";
			break;
		}
		break;
	case 1:	// Druga kolumna (produkt)
		// Generacja wartoci losowej pomidzy 0 i 4
		iCase = (rand() % 5);
		// Jaka warto zostaa wygenerowana?
		switch (iCase)
		{
		case 0:
			// 0 - Kopiarki
			strStr = "Kopiarki";
			break;
		case 1:
			// 1 - Monitory
			strStr = "Monitory";
			break;
		case 2:
			// 2 - Biurka
			strStr = "Biurka";
			break;
		case 3:
			// 3 - Fotele
			strStr = "Fotele";
			break;
		default:
			// 4 - Lampy
			strStr = "Lampy";
			break;
		}
		break;
	case 2:	// Trzecia kolumna (pracownik)
		// Generacja wartoci losowej pomidzy 0 i 3
		iCase = (rand() % 4);
		// Jaka warto zostaa wygenerowana?
		switch (iCase)
		{
		case 0:
			// 0 - Ela
			strStr = "Ela";
			break;
		case 1:
			// 1 - Bartek
			strStr = "Bartek";
			break;
		case 2:
			// 2 - Janusz
			strStr = "Janusz";
			break;
		default:
			// 3 - Jola
			strStr = "Jola";
			break;
		}
		break;
	}
	// Zwrcenie wygenerowanego acucha
	return strStr;
}

void CActiveXDlg::Sortuj()
{
	// Ustawienie biecej kolumny na zerow
	m_ctlFGrid.SetCol(0);
	// Wybranie wszystkich kolumn
	m_ctlFGrid.SetColSel((m_ctlFGrid.GetCols() - 1));
	// Sortowanie rosnce
	m_ctlFGrid.SetSort(1);
}

BEGIN_EVENTSINK_MAP(CActiveXDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CActiveXDlg)
	ON_EVENT(CActiveXDlg, IDC_MSFGRID, -605 /* MouseDown */, OnMouseDownMsfgrid, VTS_I2 VTS_I2 VTS_I4 VTS_I4)
	ON_EVENT(CActiveXDlg, IDC_MSFGRID, -607 /* MouseUp */, OnMouseUpMsfgrid, VTS_I2 VTS_I2 VTS_I4 VTS_I4)
	ON_EVENT(CActiveXDlg, IDC_MSFGRID, -601 /* DblClick */, OnDblClickMsfgrid, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CActiveXDlg::OnMouseDownMsfgrid(short Button, short Shift, long x, long y) 
{
	// TODO: Add your control notification handler code here
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Czy uytkownik klikn na wierszu danych, a nie
	// na wierszu nagwka
	if (m_ctlFGrid.GetMouseRow() != 0)
	{
		// Jeli tak, przypisanie zmiennej kolumny wartoci 0
		// i wyjcie z funkcji
		m_iKolMyszy = 0;
		return;
	}
	// Zapisanie kolumny na ktrej kliknito
	m_iKolMyszy = m_ctlFGrid.GetMouseCol();

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CActiveXDlg::OnMouseUpMsfgrid(short Button, short Shift, long x, long y) 
{
	// TODO: Add your control notification handler code here
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------

	// Jeeli wybrana zostaa pierwsza kolumna
	// nie ma adnego zadania do wykonania
	if (m_iKolMyszy == 0)
		return;
	// Wyczenie kontroli odwieania
	m_ctlFGrid.SetRedraw(FALSE);
	// Zmiana pozycji wybranej kolumny
	m_ctlFGrid.SetColPosition(m_iKolMyszy, m_ctlFGrid.GetMouseCol());
	// Sortowanie siatki
	Sortuj();
	// Ponowne wczenie odwieania
	m_ctlFGrid.SetRedraw(TRUE);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------
}

void CActiveXDlg::OnDblClickMsfgrid() 
{
	// TODO: Add your control notification handler code here
	
	//-----------------------------------------
	// POCZTEK NOWGO KODU RDOWEGO
	//-----------------------------------------


	// Czy uytkownik klikn na wierszu danych, a nie
	// na wierszu nagwka
	if (m_ctlFGrid.GetMouseRow() != 0)
	{
		// Jeli tak, wyzeruj zmienn kolumny
		// i wyjd
		m_iKolMyszy = 0;
		return;
	}
	m_iKolMyszy = m_ctlFGrid.GetMouseCol();
	// Jeeli wybran kolumn bya pierwsza kolumna
	// nie wykonuj nic
	if (m_iKolMyszy == 0)
		return;
	// Wyczenie odwieania kontrolki
	m_ctlFGrid.SetRedraw(FALSE);
	// Zmiana pozycji wyselekcjonowanej kolumny
	m_ctlFGrid.SetColPosition(m_iKolMyszy, 0);
	// Ponowne posortowanie siatki
	Sortuj();
	// Przywrcenie odwieania
	m_ctlFGrid.SetRedraw(TRUE);

	//-----------------------------------------
	// KONIEC NOWGO KODU RDOWEGO
	//-----------------------------------------

}
