// Linia.cpp: implementation of the CLinia class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "Linia.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_SERIAL (CLinia, CObject, 1)
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CLinia::CLinia(CPoint ptOd, CPoint ptDo,COLORREF crKolor)
{
		// Inicjalizacja punktw od i do
		m_ptOd = ptOd;
		m_ptDo = ptDo;
		m_crKolor = crKolor;
}


CLinia::~CLinia()
{

}


	CLinia::CLinia()
	{



	}



	void CLinia::Rysuj(CDC * pDC)
	{
		// Utworzenie pira
		CPen lpioro (PS_SOLID, 10, m_crKolor);
		
		// Ustawienie nowego pira jako obiektu rysujcego
		CPen* pStarePioro = pDC -> SelectObject(&lpioro);
		// Rysowanie linii
		pDC -> MoveTo(m_ptOd);
		pDC -> LineTo(m_ptDo);
		// Zresetowanie poprzedniego pira
		pDC -> SelectObject(pStarePioro);
	}



	void CLinia::Serialize(CArchive &ar)
	{
		CObject::Serialize(ar);

		if (ar.IsStoring())
		    ar << m_ptOd << m_ptDo << (DWORD) m_crKolor;
		else
		    ar >> m_ptOd >> m_ptDo >> (DWORD) m_crKolor;
	}

