// SdiView.cpp : implementation of the CSdiView class
//

#include "stdafx.h"
#include "Sdi.h"

#include "Linia.h"
#include "SdiDoc.h"
#include "SdiView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSdiView

IMPLEMENT_DYNCREATE(CSdiView, CView)

BEGIN_MESSAGE_MAP(CSdiView, CView)
	//{{AFX_MSG_MAP(CSdiView)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSdiView construction/destruction

CSdiView::CSdiView()
{
	// TODO: add construction code here

}

CSdiView::~CSdiView()
{
}

BOOL CSdiView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CSdiView drawing

void CSdiView::OnDraw(CDC* pDC)
{
	CSdiDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
 	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Pobranie iloci linii w dokumencie
	int liLiczbaLini = pDoc->PobierzLiczbeLini();

	// Czy w dokumencie s jakiekolwiek linie?
	if (liLiczbaLini)
	{
		int liPoz;
		CLinia *lptLinia;

		// Ptla wykonywana dla wszystkich linii w dokumencie
		for (liPoz = 0; liPoz < liLiczbaLini; liPoz++)
		{
			// Pobranie punktw Od i Do dla kadej linii
			lptLinia = pDoc->PobierzLinie(liPoz);
			// Rysowanie linii
			lptLinia->Rysuj(pDC);
		}
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------
}

/////////////////////////////////////////////////////////////////////////////
// CSdiView printing

BOOL CSdiView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CSdiView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CSdiView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CSdiView diagnostics

#ifdef _DEBUG
void CSdiView::AssertValid() const
{
	CView::AssertValid();
}

void CSdiView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSdiDoc* CSdiView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSdiDoc)));
	return (CSdiDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSdiView message handlers

void CSdiView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Przechwycenie myszy, tak aby adna inna aplikacja
	// nie moga z niej korzysta, kiedy opuci okno aplikacji
	SetCapture();
	// Zachowanie pozycji myszy
	m_ptOstatniaPoz = point;

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnLButtonDown(nFlags, point);
}

void CSdiView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------

	// Czy mysz zostaa przechwycona?
	if (GetCapture() == this)
		// Jeeli tak, zwolni j, aby inne aplikacje mogy
		// z niej korzysta
		ReleaseCapture();

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnLButtonUp(nFlags, point);
}

void CSdiView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	//-----------------------------------------
	// POCZTEK NOWEGO KODU RDOWEGO
	//-----------------------------------------
	
	// Sprawdzenie, czy lewy przycisk myszy jest przytrzymany
	if ((nFlags & MK_LBUTTON) == MK_LBUTTON)
	{
		// Czy zostaa przechwycona mysz?
		if (GetCapture() == this)
		{
			// Pobranie kontekstu urzdzenia
			CClientDC dc(this);

			// Dodanie linii do dokumentu
			CLinia *pLinia = GetDocument()->DodajLinie(m_ptOstatniaPoz, point);

			// Rysowanie aktualnej linii
			pLinia->Rysuj(&dc);

			// Zapisanie aktualnej pozycji jako poprzedniej
			m_ptOstatniaPoz = point;
		}
	}

	//-----------------------------------------
	// KONIEC NOWEGO KODU RDOWEGO
	//-----------------------------------------

	CView::OnMouseMove(nFlags, point);
}

void CSdiView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CMenu *m_lMenu;
	CPoint m_pPunkt;

	m_pPunkt = point;
	ClientToScreen(&m_pPunkt);
	m_lMenu = GetMenu();
	if (m_lMenu)
	{
	//m_lMenu = m_lMenu->GetSubMenu(0);
	m_lMenu->TrackPopupMenu(TPM_CENTERALIGN + TPM_LEFTBUTTON, 
		m_pPunkt.x, m_pPunkt.y, this, NULL);
	}
	CView::OnRButtonDown(nFlags, point);
}
