// PaintDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Grafika.h"
#include "PaintDlg.h"
#include "GrafikaDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
	const COLORREF CPaintDlg:: m_crKolory[8] = {
	RGB(   0,   0,   0),	// Czarny
	RGB(   0,   0, 255),	// Niebieski
	RGB(   0, 255,   0),	// Zielony
	RGB(   0, 255, 255),	// Bkitny
	RGB( 255,   0,   0),	// Czerwony
	RGB( 255,   0, 255),	// Fioletowy
	RGB( 255, 255,   0),	// ty
	RGB( 255, 255, 255)		// Biay
};


/////////////////////////////////////////////////////////////////////////////
// CPaintDlg dialog


CPaintDlg::CPaintDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPaintDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPaintDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPaintDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPaintDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPaintDlg, CDialog)
	//{{AFX_MSG_MAP(CPaintDlg)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPaintDlg message handlers

	void CPaintDlg::RysujLinie(CPaintDC *pdc, int iKolor)
	{
		// Deklaracja i utworzenie pir
		CPen lSolidPen (PS_SOLID, 1, m_crKolory[iKolor]);
		CPen lDotPen (PS_DOT, 1, m_crKolory[iKolor]);
		CPen lDashPen (PS_DASH, 1, m_crKolory[iKolor]);
		CPen lDashDotPen (PS_DASHDOT, 1, m_crKolory[iKolor]);
		CPen lDashDotDotPen (PS_DASHDOTDOT, 1, m_crKolory[iKolor]);
		CPen lNullPen (PS_NULL, 1, m_crKolory[iKolor]);
		CPen lInsidePen (PS_INSIDEFRAME, 1, m_crKolory[iKolor]);

		// Pobranie obszaru rysowania
		CRect lObszar;
		GetClientRect(lObszar);
		lObszar.NormalizeRect();

		// Obliczenie odlegoci midzy poszczeglnymi liniami
		CPoint pPoczatek;
		CPoint pKoniec;
		int liDyst = lObszar.Height() / 8;
		CPen *lOldPen;
		// Ustalenie punktw startowych
		pPoczatek.y = lObszar.top;
		pPoczatek.x = lObszar.left;
		pKoniec.y = pPoczatek.y;
		pKoniec.x = lObszar.right;
		int i;
		// Ptla wykonywana dla kolejnych pir
		for (i = 0; i < 7; i++)
	{
			// Ktre piro jest aktualnie wybrane?
			switch (i)
			{
			case 0:	// Solid
				lOldPen = pdc->SelectObject(&lSolidPen);
				break;
			case 1:	// Dot
				pdc->SelectObject(&lDotPen);
				break;
			case 2:	// Dash
				pdc->SelectObject(&lDashPen);
				break;
			case 3:	// Dash Dot
				pdc->SelectObject(&lDashDotPen);
				break;
			case 4:	// Dash Dot Dot
				pdc->SelectObject(&lDashDotDotPen);
				break;
			case 5:	// Null
				pdc->SelectObject(&lNullPen);
				break;
			case 6:	// Inside
				pdc->SelectObject(&lInsidePen);
				break;
			}
			// Przejcie o jedn pozycj niej
			pPoczatek.y = pPoczatek.y + liDyst;
			pKoniec.y = pPoczatek.y;
			// Rysowanie linii
			pdc->MoveTo(pPoczatek);
			pdc->LineTo(pKoniec);
		}
		// Wybranie oryginalnego pira
		pdc->SelectObject(lOldPen);
	}


	void CPaintDlg::OnPaint() 
	{
		CPaintDC dc(this); // device context for painting
	
		// TODO: Add your message handler code here

		// Pobranie wskanika do okna nadrzdnego 
		CGrafikaDlg *pWnd = (CGrafikaDlg*)GetParent();
	// Czy utworzony zosta prawidowy wskanik?
		if (pWnd)
		{
			// Czy narzdzie jest bitmap?
			if (pWnd ->m_iNarzedzie == 2)
			{
				// Czy zostaa zaadowana i wybrana bitmapa?
				if (pWnd->m_sBitmapa !="")
					// Wywietlenie bitmapy
					PokazBitmape(&dc, pWnd);
			}
			else	// Nie, rysowany jest pewien ksztat
			{
				// Czy rysowana jest linia?
				if (pWnd ->m_iKsztalt == 0)
					RysujLinie(&dc, pWnd -> m_iKolor);
			else // Rysowany jest obszar (prostokt lub okrg)
				RysujObszar(&dc, pWnd ->m_iKolor, pWnd ->m_iNarzedzie, pWnd -> m_iKsztalt);
			}
		}
		// Do not call CDialog::OnPaint() for painting messages
	}	



void CPaintDlg::RysujObszar(CPaintDC *pdc, int iKolor, int iNarzedzie, int iKsztalt)
{
	// Deklaracja i utworzenie pir
	CPen lSolidPen (PS_SOLID, 1, m_crKolory[iKolor]);
	CPen lDotPen (PS_DOT, 1, m_crKolory[iKolor]);
	CPen lDashPen (PS_DASH, 1, m_crKolory[iKolor]);
	CPen lDashDotPen (PS_DASHDOT, 1, m_crKolory[iKolor]);
	CPen lDashDotDotPen (PS_DASHDOTDOT, 1, m_crKolory[iKolor]);
	CPen lNullPen (PS_NULL, 1, m_crKolory[iKolor]);
	CPen lInsidePen (PS_INSIDEFRAME, 1, m_crKolory[iKolor]);

	// Deklaracja i utworzenie pdzli
	CBrush lSolidBrush(m_crKolory[iKolor]);
	CBrush lBDiagBrush(HS_BDIAGONAL, m_crKolory[iKolor]);
	CBrush lCrossBrush(HS_CROSS, m_crKolory[iKolor]);
	CBrush lDiagCrossBrush(HS_DIAGCROSS, m_crKolory[iKolor]);
	CBrush lFDiagBrush(HS_FDIAGONAL, m_crKolory[iKolor]);
	CBrush lHorizBrush(HS_HORIZONTAL, m_crKolory[iKolor]);
	CBrush lVertBrush(HS_VERTICAL, m_crKolory[iKolor]);
	CBrush lNullBrush(RGB(192, 192, 192));

	// Obliczenie rozmiaru obszarw przeznaczonych na rysunki
	CRect lObszar;
	GetClientRect(lObszar);
	lObszar.NormalizeRect();
	int iPion = lObszar.Height() / 2;
	int iWysokosc = iPion - 10;
	int iPoziom = lObszar.Width() / 4;
	int iSzerokosc = iPoziom - 10;
	CRect lObszarRysowania;
	CPen *pOldPen;
	CBrush *pOldBrush;
	int i;
	// Ptla wykonywana dla wszystkich pir i pdzli
	for (i = 0; i < 7; i++)
	{
		switch (i)
		{
		case 0:	// Solid
			// Okrelenie lokalizacji dla figury.
			// Rozpoczcie pierwszego rzdu 
			lObszarRysowania.top = lObszar.top + 5;
			lObszarRysowania.left = lObszar.left + 5;
			lObszarRysowania.bottom = lObszarRysowania.top + iWysokosc;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Select the appropriate pen and brush
			pOldPen = pdc->SelectObject(&lSolidPen);
			pOldBrush = pdc->SelectObject(&lSolidBrush);
			break;
		case 1:	// Dot - Back Diagonal
			// Okrelenie lokalizacji dla figury.
			lObszarRysowania.left = lObszarRysowania.left + iPoziom;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla
			pdc->SelectObject(&lDotPen);
			pdc->SelectObject(&lBDiagBrush);
			break;
		case 2:	// Dash - Cross Brush
			// Okrelenie lokalizacji dla figury.
			lObszarRysowania.left = lObszarRysowania.left + iPoziom;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla
			pdc->SelectObject(&lDashPen);
			pdc->SelectObject(&lCrossBrush);
			break;
		case 3:	// Dash Dot - Diagonal Cross
			// Okrelenie lokalizacji dla figury
			lObszarRysowania.left = lObszarRysowania.left + iPoziom;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla.
			pdc->SelectObject(&lDashDotPen);
			pdc->SelectObject(&lDiagCrossBrush);
			break;
		case 4:	// Dash Dot Dot - Forward Diagonal
			// Okrelenie lokalizacji dla figury.
			// Pocztek drugiego rzdu 
			lObszarRysowania.top = lObszarRysowania.top + iPion;
			lObszarRysowania.left = lObszar.left + 5;
			lObszarRysowania.bottom = lObszarRysowania.top + iWysokosc;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla
			pdc->SelectObject(&lDashDotDotPen);
			pdc->SelectObject(&lFDiagBrush);
			break;
		case 5:	// Null - Horizontal
			// Okrelenie lokalizacji dla figury.
			lObszarRysowania.left = lObszarRysowania.left + iPoziom;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla
			pdc->SelectObject(&lNullPen);
			pdc->SelectObject(&lHorizBrush);
			break;
		case 6:	// Inside - Vertical
			// Okrelenie lokalizacji dla figury.
			lObszarRysowania.left = lObszarRysowania.left + iPoziom;
			lObszarRysowania.right = lObszarRysowania.left + iSzerokosc;
			// Wybranie odpowiedniego pira i pdzla
			pdc->SelectObject(&lInsidePen);
			pdc->SelectObject(&lVertBrush);
			break;
		}
		// Jakie narzdzie jest uywane?
		if (iNarzedzie == 0)
			pdc->SelectObject(lNullBrush);
		else
			pdc->SelectObject(lNullPen);
		// Jak ksztat jest uywany do rysowania?
		if (iKsztalt == 1)
			pdc->Ellipse(lObszarRysowania);
		else
			pdc->Rectangle(lObszarRysowania);
	}
	// Reset the original brush and pen
	pdc->SelectObject(pOldBrush);
	pdc->SelectObject(pOldPen);
}

void CPaintDlg::PokazBitmape(CPaintDC *pdc, CWnd *pWnd)
{
	
	// Konwersja wskanika na wskanik do klasy gwengo okna dialogowego
	CGrafikaDlg *lpWnd = (CGrafikaDlg*)pWnd;
	BITMAP bm;
	CDC dcMem;
	CRect lObszar;

	// Pobranie zaadowanej bitmapy
	lpWnd->m_bmpBitmapa.GetBitmap(&bm);
	// Utworzenie kontekstu urzdzenia, aby zaddowa do niego bitmap
	dcMem.CreateCompatibleDC(pdc);
	// Wybranie bitmapy dla kompatybilnego kontekstu urzdzenia
	CBitmap* pOldBitmap = (CBitmap*)dcMem.SelectObject(lpWnd->m_bmpBitmapa);
	// Pobranie dostpnego obszaru wywietlania
	GetClientRect(lObszar);
	lObszar.NormalizeRect();
	// Kopiowanie (i zmiana romiaru) bitmapy do okna dialogowego
	pdc->StretchBlt(10, 10, (lObszar.Width() - 20), (lObszar.Height() - 20), &dcMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
}
